/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface OptionDescriber {
    public IteratorOptions describeOptions();

    public boolean validateOptions(Map<String, String> var1);

    public static class IteratorOptions {
        public LinkedHashMap<String, String> namedOptions;
        public ArrayList<String> unnamedOptionDescriptions;
        public String name;
        public String description;

        public IteratorOptions(String name, String description, Map<String, String> namedOptions, List<String> unnamedOptionDescriptions) {
            this.name = name;
            this.namedOptions = null;
            if (namedOptions != null) {
                this.namedOptions = new LinkedHashMap<String, String>(namedOptions);
            }
            this.unnamedOptionDescriptions = null;
            if (unnamedOptionDescriptions != null) {
                this.unnamedOptionDescriptions = new ArrayList<String>(unnamedOptionDescriptions);
            }
            this.description = description;
        }

        public Map<String, String> getNamedOptions() {
            return this.namedOptions;
        }

        public List<String> getUnnamedOptionDescriptions() {
            return this.unnamedOptionDescriptions;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setNamedOptions(Map<String, String> namedOptions) {
            this.namedOptions = new LinkedHashMap<String, String>(namedOptions);
        }

        public void setUnnamedOptionDescriptions(List<String> unnamedOptionDescriptions) {
            this.unnamedOptionDescriptions = new ArrayList<String>(unnamedOptionDescriptions);
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void addNamedOption(String name, String description) {
            if (this.namedOptions == null) {
                this.namedOptions = new LinkedHashMap();
            }
            this.namedOptions.put(name, description);
        }

        public void addUnnamedOption(String description) {
            if (this.unnamedOptionDescriptions == null) {
                this.unnamedOptionDescriptions = new ArrayList();
            }
            this.unnamedOptionDescriptions.add(description);
        }
    }
}

