/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.AutoExpandingBufferWriteTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class ThriftMessageUtil {
    private final AutoExpandingBufferWriteTransport transport;
    private final TProtocol protocol;

    public ThriftMessageUtil() {
        this(64, 1.5);
    }

    public ThriftMessageUtil(int initialCapacity, double growthCoefficient) {
        this.transport = new AutoExpandingBufferWriteTransport(initialCapacity, growthCoefficient);
        this.protocol = new TCompactProtocol((TTransport)this.transport);
    }

    public ByteBuffer serialize(TBase<?, ?> msg) throws IOException {
        Objects.requireNonNull(msg);
        this.transport.reset();
        try {
            msg.write(this.protocol);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return ByteBuffer.wrap(this.transport.getBuf().array(), 0, this.transport.getPos());
    }

    public <T extends TBase<?, ?>> T deserialize(byte[] serialized, T instance) throws IOException {
        return this.deserialize(serialized, 0, serialized.length, instance);
    }

    public <T extends TBase<?, ?>> T deserialize(byte[] serialized, int offset, int length, T instance) throws IOException {
        Objects.requireNonNull(instance);
        TCompactProtocol proto = new TCompactProtocol((TTransport)new TMemoryInputTransport(serialized, offset, length));
        try {
            instance.read((TProtocol)proto);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return instance;
    }
}

