/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.OperatorBuffer;
import com.esri.core.geometry.OperatorBufferCursor;
import com.esri.core.geometry.OperatorUnion;
import com.esri.core.geometry.ProgressTracker;
import com.esri.core.geometry.SimpleGeometryCursor;
import com.esri.core.geometry.SpatialReference;

class OperatorBufferLocal
extends OperatorBuffer {
    OperatorBufferLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, SpatialReference sr, double[] distances, boolean bUnion, ProgressTracker progressTracker) {
        return this.execute(inputGeometries, sr, distances, NumberUtils.NaN(), 96, bUnion, progressTracker);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, SpatialReference sr, double distance, ProgressTracker progressTracker) {
        SimpleGeometryCursor inputCursor = new SimpleGeometryCursor(inputGeometry);
        double[] distances = new double[]{distance};
        GeometryCursor outputCursor = this.execute(inputCursor, sr, distances, false, progressTracker);
        return outputCursor.next();
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, SpatialReference sr, double[] distances, double max_deviation, int max_vertices_in_full_circle, boolean b_union, ProgressTracker progressTracker) {
        if (b_union) {
            OperatorBufferCursor cursor = new OperatorBufferCursor(inputGeometries, sr, distances, max_deviation, max_vertices_in_full_circle, false, progressTracker);
            return OperatorUnion.local().execute(cursor, sr, progressTracker);
        }
        return new OperatorBufferCursor(inputGeometries, sr, distances, max_deviation, max_vertices_in_full_circle, false, progressTracker);
    }
}

