/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata;

import java.util.ArrayList;
import java.util.List;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ConstraintMetaData;
import org.datanucleus.metadata.ForeignKeyAction;
import org.datanucleus.util.StringUtils;

public class ForeignKeyMetaData
extends ConstraintMetaData {
    private static final long serialVersionUID = 3207934394330383432L;
    protected List<ColumnMetaData> columns = null;
    protected boolean unique = false;
    protected boolean deferred = false;
    protected ForeignKeyAction deleteAction;
    protected ForeignKeyAction updateAction;
    protected String fkDefinition = null;
    protected boolean fkDefinitionApplies = false;

    public ForeignKeyMetaData() {
    }

    public ForeignKeyMetaData(ForeignKeyMetaData fkmd) {
        super(fkmd);
        if (fkmd.columns != null) {
            for (ColumnMetaData colmd : fkmd.columns) {
                this.addColumn(new ColumnMetaData(colmd));
            }
        }
        this.unique = fkmd.unique;
        this.deferred = fkmd.deferred;
        this.deleteAction = fkmd.deleteAction;
        this.updateAction = fkmd.updateAction;
    }

    public void addColumn(ColumnMetaData colmd) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnMetaData>();
        }
        this.columns.add(colmd);
        this.addColumn(colmd.getName());
        colmd.parent = this;
    }

    public ColumnMetaData newColumnMetaData() {
        ColumnMetaData colmd = new ColumnMetaData();
        this.addColumn(colmd);
        return colmd;
    }

    public final ColumnMetaData[] getColumnMetaData() {
        return this.columns == null ? null : this.columns.toArray(new ColumnMetaData[this.columns.size()]);
    }

    public final boolean isDeferred() {
        return this.deferred;
    }

    public ForeignKeyMetaData setDeferred(boolean deferred) {
        this.deferred = deferred;
        return this;
    }

    public ForeignKeyMetaData setDeferred(String deferred) {
        if (!StringUtils.isWhitespace(deferred)) {
            this.deferred = Boolean.parseBoolean(deferred);
        }
        return this;
    }

    public final ForeignKeyAction getDeleteAction() {
        return this.deleteAction;
    }

    public void setDeleteAction(ForeignKeyAction deleteAction) {
        this.deleteAction = deleteAction;
    }

    public final boolean isUnique() {
        return this.unique;
    }

    public ForeignKeyMetaData setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public ForeignKeyMetaData setUnique(String unique) {
        if (!StringUtils.isWhitespace(unique)) {
            this.deferred = Boolean.parseBoolean(unique);
        }
        return this;
    }

    public final ForeignKeyAction getUpdateAction() {
        return this.updateAction;
    }

    public ForeignKeyMetaData setUpdateAction(ForeignKeyAction updateAction) {
        this.updateAction = updateAction;
        return this;
    }

    public void setFkDefinition(String def) {
        if (StringUtils.isWhitespace(def)) {
            return;
        }
        this.fkDefinition = def;
        this.fkDefinitionApplies = true;
        this.updateAction = null;
        this.deleteAction = null;
    }

    public String getFkDefinition() {
        return this.fkDefinition;
    }

    public void setFkDefinitionApplies(boolean flag) {
        this.fkDefinitionApplies = flag;
    }

    public boolean getFkDefinitionApplies() {
        return this.fkDefinitionApplies;
    }
}

