/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.expression;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.query.compiler.PropertySymbol;
import org.datanucleus.store.query.compiler.Symbol;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.util.StringUtils;

public class CreatorExpression
extends Expression {
    private static final long serialVersionUID = -6455308731943969503L;
    List<String> tuples;
    List<Expression> arguments;

    public CreatorExpression(List<String> tuples, List<Expression> args) {
        this.tuples = tuples;
        this.arguments = args;
        if (args != null && !args.isEmpty()) {
            Iterator<Expression> argIter = args.iterator();
            while (argIter.hasNext()) {
                argIter.next().parent = this;
            }
        }
    }

    public String getId() {
        StringBuilder id = new StringBuilder();
        for (String tuple : this.tuples) {
            if (id.length() > 0) {
                id.append('.');
            }
            id.append(tuple);
        }
        return id.toString();
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public List getTuples() {
        return this.tuples;
    }

    @Override
    public Symbol bind(SymbolTable symtbl) {
        if (symtbl.hasSymbol(this.getId())) {
            this.symbol = symtbl.getSymbol(this.getId());
        } else {
            try {
                Class cls = symtbl.getSymbolResolver().resolveClass(this.getId());
                this.symbol = new PropertySymbol(this.getId(), cls);
            }
            catch (ClassNotResolvedException cnre) {
                throw new NucleusUserException("CreatorExpression defined with class of " + this.getId() + " yet this class is not found");
            }
        }
        return this.symbol;
    }

    public String toString() {
        return "CreatorExpression{" + this.getId() + "(" + StringUtils.collectionToString(this.arguments) + ")}" + (String)(this.alias != null ? " AS " + this.alias : "");
    }
}

