/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.BitSet;

public class ArrayConversionHelper {
    private static int NR_BIGINTEGER_BYTES = 40;
    private static int NR_SCALE_BYTES = 4;
    private static int NR_SIGNAL_BYTES = 1;
    private static int TOTAL_BYTES = NR_BIGINTEGER_BYTES + NR_SCALE_BYTES + NR_SIGNAL_BYTES;

    public static boolean[] getBooleanArrayFromBitSet(BitSet value) {
        if (value == null) {
            return null;
        }
        boolean[] a = new boolean[value.length()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = value.get(i);
        }
        return a;
    }

    public static BitSet getBitSetFromBooleanArray(boolean[] buf) {
        BitSet set = new BitSet();
        for (int i = 0; i < buf.length; ++i) {
            if (!buf[i]) continue;
            set.set(i);
        }
        return set;
    }

    public static boolean[] getBooleanArrayFromByteArray(byte[] buf) {
        int n = buf.length;
        boolean[] a = new boolean[n];
        for (int i = 0; i < n; ++i) {
            a[i] = buf[i] != 0;
        }
        return a;
    }

    public static byte[] getByteArrayFromBooleanArray(boolean[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = value[i] ? (byte)1 : 0;
        }
        return buf;
    }

    public static char[] getCharArrayFromByteArray(byte[] buf) {
        int n = buf.length / 2;
        char[] a = new char[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = (char)(((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromCharArray(char[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            char x = value[i++];
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static double[] getDoubleArrayFromByteArray(byte[] buf) {
        int n = buf.length / 8;
        double[] a = new double[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = Double.longBitsToDouble(((long)(buf[j++] & 0xFF) << 56) + ((long)(buf[j++] & 0xFF) << 48) + ((long)(buf[j++] & 0xFF) << 40) + ((long)(buf[j++] & 0xFF) << 32) + ((long)(buf[j++] & 0xFF) << 24) + (long)((buf[j++] & 0xFF) << 16) + (long)((buf[j++] & 0xFF) << 8) + (long)(buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromDoubleArray(double[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 8];
        int i = 0;
        int j = 0;
        while (i < n) {
            long x = Double.doubleToRawLongBits(value[i++]);
            buf[j++] = (byte)(x >>> 56 & 0xFFL);
            buf[j++] = (byte)(x >>> 48 & 0xFFL);
            buf[j++] = (byte)(x >>> 40 & 0xFFL);
            buf[j++] = (byte)(x >>> 32 & 0xFFL);
            buf[j++] = (byte)(x >>> 24 & 0xFFL);
            buf[j++] = (byte)(x >>> 16 & 0xFFL);
            buf[j++] = (byte)(x >>> 8 & 0xFFL);
            buf[j++] = (byte)(x & 0xFFL);
        }
        return buf;
    }

    public static float[] getFloatArrayFromByteArray(byte[] buf) {
        int n = buf.length / 4;
        float[] a = new float[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = Float.intBitsToFloat(((buf[j++] & 0xFF) << 24) + ((buf[j++] & 0xFF) << 16) + ((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromFloatArray(float[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 4];
        int i = 0;
        int j = 0;
        while (i < n) {
            int x = Float.floatToRawIntBits(value[i++]);
            buf[j++] = (byte)(x >>> 24 & 0xFF);
            buf[j++] = (byte)(x >>> 16 & 0xFF);
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static int[] getIntArrayFromByteArray(byte[] buf) {
        int n = buf.length / 4;
        int[] a = new int[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = ((buf[j++] & 0xFF) << 24) + ((buf[j++] & 0xFF) << 16) + ((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF);
        }
        return a;
    }

    public static byte[] getByteArrayFromIntArray(int[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 4];
        int i = 0;
        int j = 0;
        while (i < n) {
            int x = value[i++];
            buf[j++] = (byte)(x >>> 24 & 0xFF);
            buf[j++] = (byte)(x >>> 16 & 0xFF);
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static long[] getLongArrayFromByteArray(byte[] buf) {
        int n = buf.length / 8;
        long[] a = new long[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = ((long)(buf[j++] & 0xFF) << 56) + ((long)(buf[j++] & 0xFF) << 48) + ((long)(buf[j++] & 0xFF) << 40) + ((long)(buf[j++] & 0xFF) << 32) + ((long)(buf[j++] & 0xFF) << 24) + (long)((buf[j++] & 0xFF) << 16) + (long)((buf[j++] & 0xFF) << 8) + (long)(buf[j++] & 0xFF);
        }
        return a;
    }

    public static byte[] getByteArrayFromLongArray(long[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 8];
        int i = 0;
        int j = 0;
        while (i < n) {
            long x = value[i++];
            buf[j++] = (byte)(x >>> 56 & 0xFFL);
            buf[j++] = (byte)(x >>> 48 & 0xFFL);
            buf[j++] = (byte)(x >>> 40 & 0xFFL);
            buf[j++] = (byte)(x >>> 32 & 0xFFL);
            buf[j++] = (byte)(x >>> 24 & 0xFFL);
            buf[j++] = (byte)(x >>> 16 & 0xFFL);
            buf[j++] = (byte)(x >>> 8 & 0xFFL);
            buf[j++] = (byte)(x & 0xFFL);
        }
        return buf;
    }

    public static short[] getShortArrayFromByteArray(byte[] buf) {
        int n = buf.length / 2;
        short[] a = new short[n];
        int i = 0;
        int j = 0;
        while (i < n) {
            a[i++] = (short)(((buf[j++] & 0xFF) << 8) + (buf[j++] & 0xFF));
        }
        return a;
    }

    public static byte[] getByteArrayFromShortArray(short[] value) {
        if (value == null) {
            return null;
        }
        int n = value.length;
        byte[] buf = new byte[n * 2];
        int i = 0;
        int j = 0;
        while (i < n) {
            short x = value[i++];
            buf[j++] = (byte)(x >>> 8 & 0xFF);
            buf[j++] = (byte)(x & 0xFF);
        }
        return buf;
    }

    public static byte[] getByteArrayFromBigDecimalArray(BigDecimal[] value) {
        if (value == null) {
            return null;
        }
        byte[] total = new byte[value.length * TOTAL_BYTES];
        int index = 0;
        for (int i = 0; i < value.length; ++i) {
            System.arraycopy(new byte[]{(byte)value[i].signum()}, 0, total, index, NR_SIGNAL_BYTES);
            byte[] b = value[i].unscaledValue().abs().toByteArray();
            System.arraycopy(b, 0, total, (index += NR_SIGNAL_BYTES) + (NR_BIGINTEGER_BYTES - b.length), b.length);
            byte[] s = ArrayConversionHelper.getByteArrayFromIntArray(new int[]{value[i].scale()});
            System.arraycopy(s, 0, total, index += NR_BIGINTEGER_BYTES, NR_SCALE_BYTES);
            index += NR_SCALE_BYTES;
        }
        return total;
    }

    public static BigDecimal[] getBigDecimalArrayFromByteArray(byte[] buf) {
        BigDecimal[] a = new BigDecimal[buf.length / TOTAL_BYTES];
        int index = 0;
        for (int i = 0; i < a.length; ++i) {
            byte[] signal = new byte[NR_SIGNAL_BYTES];
            System.arraycopy(buf, index, signal, 0, NR_SIGNAL_BYTES);
            byte[] b = new byte[NR_BIGINTEGER_BYTES];
            System.arraycopy(buf, index += NR_SIGNAL_BYTES, b, 0, NR_BIGINTEGER_BYTES);
            BigInteger integer = new BigInteger((int)signal[0], b);
            byte[] s = new byte[4];
            System.arraycopy(buf, index += NR_BIGINTEGER_BYTES, s, 0, NR_SCALE_BYTES);
            int[] scale = ArrayConversionHelper.getIntArrayFromByteArray(s);
            a[i] = new BigDecimal(integer, scale[0]);
            index += NR_SCALE_BYTES;
        }
        return a;
    }

    public static byte[] getByteArrayFromBigIntegerArray(BigInteger[] value) {
        if (value == null) {
            return null;
        }
        long[] d = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i].longValue();
        }
        return ArrayConversionHelper.getByteArrayFromLongArray(d);
    }

    public static BigInteger[] getBigIntegerArrayFromByteArray(byte[] buf) {
        long[] d = ArrayConversionHelper.getLongArrayFromByteArray(buf);
        BigInteger[] a = new BigInteger[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = BigInteger.valueOf(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromBooleanObjectArray(Boolean[] value) {
        if (value == null) {
            return null;
        }
        boolean[] d = new boolean[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return ArrayConversionHelper.getByteArrayFromBooleanArray(d);
    }

    public static Boolean[] getBooleanObjectArrayFromByteArray(byte[] buf) {
        boolean[] d = ArrayConversionHelper.getBooleanArrayFromByteArray(buf);
        Boolean[] a = new Boolean[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }

    public static byte[] getByteArrayFromByteObjectArray(Byte[] value) {
        if (value == null) {
            return null;
        }
        byte[] d = new byte[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return d;
    }

    public static Byte[] getByteObjectArrayFromByteArray(byte[] buf) {
        if (buf == null) {
            return null;
        }
        Byte[] a = new Byte[buf.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = buf[i];
        }
        return a;
    }

    public static byte[] getByteArrayFromCharObjectArray(Character[] value) {
        if (value == null) {
            return null;
        }
        char[] d = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i].charValue();
        }
        return ArrayConversionHelper.getByteArrayFromCharArray(d);
    }

    public static Character[] getCharObjectArrayFromByteArray(byte[] buf) {
        char[] d = ArrayConversionHelper.getCharArrayFromByteArray(buf);
        Character[] a = new Character[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Character.valueOf(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromDoubleObjectArray(Double[] value) {
        if (value == null) {
            return null;
        }
        double[] d = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return ArrayConversionHelper.getByteArrayFromDoubleArray(d);
    }

    public static Double[] getDoubleObjectArrayFromByteArray(byte[] buf) {
        double[] d = ArrayConversionHelper.getDoubleArrayFromByteArray(buf);
        Double[] a = new Double[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }

    public static byte[] getByteArrayFromFloatObjectArray(Float[] value) {
        if (value == null) {
            return null;
        }
        float[] d = new float[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i].floatValue();
        }
        return ArrayConversionHelper.getByteArrayFromFloatArray(d);
    }

    public static Float[] getFloatObjectArrayFromByteArray(byte[] buf) {
        float[] d = ArrayConversionHelper.getFloatArrayFromByteArray(buf);
        Float[] a = new Float[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = Float.valueOf(d[i]);
        }
        return a;
    }

    public static byte[] getByteArrayFromIntObjectArray(Integer[] value) {
        if (value == null) {
            return null;
        }
        int[] d = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return ArrayConversionHelper.getByteArrayFromIntArray(d);
    }

    public static Integer[] getIntObjectArrayFromByteArray(byte[] buf) {
        int[] d = ArrayConversionHelper.getIntArrayFromByteArray(buf);
        Integer[] a = new Integer[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }

    public static byte[] getByteArrayFromLongObjectArray(Long[] value) {
        if (value == null) {
            return null;
        }
        long[] d = new long[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return ArrayConversionHelper.getByteArrayFromLongArray(d);
    }

    public static Long[] getLongObjectArrayFromByteArray(byte[] buf) {
        long[] d = ArrayConversionHelper.getLongArrayFromByteArray(buf);
        Long[] a = new Long[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }

    public static byte[] getByteArrayFromShortObjectArray(Short[] value) {
        if (value == null) {
            return null;
        }
        short[] d = new short[value.length];
        for (int i = 0; i < value.length; ++i) {
            d[i] = value[i];
        }
        return ArrayConversionHelper.getByteArrayFromShortArray(d);
    }

    public static Short[] getShortObjectArrayFromByteArray(byte[] buf) {
        short[] d = ArrayConversionHelper.getShortArrayFromByteArray(buf);
        Short[] a = new Short[d.length];
        for (int i = 0; i < a.length; ++i) {
            a[i] = d[i];
        }
        return a;
    }
}

