/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedOutputStream.class);
    private DataOutputStream dout;
    private byte[] singleByte = new byte[1];
    private byte[] buffer;
    private int bufPos = 0;
    private String id;

    public ChunkedOutputStream(OutputStream out, int bufSize, String id) {
        LOG.debug("Creating chunked input stream: {}", (Object)id);
        if (bufSize <= 0) {
            throw new IllegalArgumentException("Positive bufSize required, was " + bufSize);
        }
        this.buffer = new byte[bufSize];
        this.dout = new DataOutputStream(out);
        this.id = id;
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int bytesWritten = 0;
        while (bytesWritten < len) {
            int bytesToWrite = Math.min(len - bytesWritten, this.buffer.length - this.bufPos);
            System.arraycopy(b, off + bytesWritten, this.buffer, this.bufPos, bytesToWrite);
            bytesWritten += bytesToWrite;
            this.bufPos += bytesToWrite;
            if (this.bufPos != this.buffer.length) continue;
            this.writeChunk();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writeChunk();
        LOG.debug("{}: Closing underlying output stream.", (Object)this.id);
        this.dout.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.bufPos > 0) {
            this.writeChunk();
            this.dout.flush();
        }
    }

    private void writeChunk() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Writing chunk of size {}", (Object)this.id, (Object)this.bufPos);
        }
        this.dout.writeInt(this.bufPos);
        this.dout.write(this.buffer, 0, this.bufPos);
        this.bufPos = 0;
    }
}

