/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.security.KeyStore;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.curator.utils.ZookeeperFactory;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.client.ZKClientConfig;
import org.apache.hive.org.apache.zookeeper.common.ClientX509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLZookeeperFactory
implements ZookeeperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SSLZookeeperFactory.class);
    private boolean sslEnabled;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustStoreType;

    public SSLZookeeperFactory(boolean sslEnabled, String keyStoreLocation, String keyStorePassword, String keyStoreType, String trustStoreLocation, String trustStorePassword, String trustStoreType) {
        this.sslEnabled = sslEnabled;
        this.keyStoreLocation = keyStoreLocation;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = !StringUtils.isBlank(keyStoreType) ? keyStoreType : KeyStore.getDefaultType();
        this.trustStoreLocation = trustStoreLocation;
        this.trustStorePassword = trustStorePassword;
        String string = this.trustStoreType = !StringUtils.isBlank(trustStoreType) ? trustStoreType : KeyStore.getDefaultType();
        if (sslEnabled) {
            if (StringUtils.isBlank(keyStoreLocation)) {
                LOG.warn("Missing keystoreLocation parameter");
            }
            if (StringUtils.isBlank(trustStoreLocation)) {
                LOG.warn("Missing trustStoreLocation parameter");
            }
        }
    }

    @Override
    public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
        if (!this.sslEnabled) {
            return new ZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly);
        }
        ZKClientConfig clientConfig = new ZKClientConfig();
        clientConfig.setProperty("zookeeper.client.secure", "true");
        clientConfig.setProperty("zookeeper.clientCnxnSocket", "org.apache.hive.org.apache.zookeeper.ClientCnxnSocketNetty");
        ClientX509Util x509Util = new ClientX509Util();
        clientConfig.setProperty(x509Util.getSslKeystoreLocationProperty(), this.keyStoreLocation);
        clientConfig.setProperty(x509Util.getSslKeystorePasswdProperty(), this.keyStorePassword);
        clientConfig.setProperty(x509Util.getSslKeystoreTypeProperty(), this.keyStoreType);
        clientConfig.setProperty(x509Util.getSslTruststoreLocationProperty(), this.trustStoreLocation);
        clientConfig.setProperty(x509Util.getSslTruststorePasswdProperty(), this.trustStorePassword);
        clientConfig.setProperty(x509Util.getSslTruststoreTypeProperty(), this.trustStoreType);
        return new ZooKeeper(connectString, sessionTimeout, watcher, canBeReadOnly, clientConfig);
    }
}

