/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.hive.common.io.FetchCallback;
import org.apache.hadoop.hive.common.io.SessionStream;

public abstract class FetchConverter
extends SessionStream
implements FetchCallback {
    protected volatile boolean queryfound;
    protected volatile boolean fetchStarted;

    public FetchConverter(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    @Override
    public void foundQuery(boolean queryfound) {
        this.queryfound = queryfound;
    }

    @Override
    public void fetchStarted() {
        this.fetchStarted = true;
    }

    @Override
    public void println(String out) {
        if (this.byPass()) {
            this.printDirect(out);
        } else {
            this.process(out);
        }
    }

    protected final void printDirect(String out) {
        super.println(out);
    }

    protected final boolean byPass() {
        return !this.queryfound || !this.fetchStarted;
    }

    protected abstract void process(String var1);

    protected abstract void processFinal();

    @Override
    public void flush() {
        if (this.byPass()) {
            super.flush();
        }
    }

    @Override
    public void fetchFinished() {
        if (!this.byPass()) {
            this.processFinal();
        }
        super.flush();
        this.fetchStarted = false;
    }
}

