/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hive.org.apache.thrift.EncodingUtils;
import org.apache.hive.org.apache.thrift.TBase;
import org.apache.hive.org.apache.thrift.TBaseHelper;
import org.apache.hive.org.apache.thrift.TException;
import org.apache.hive.org.apache.thrift.TFieldIdEnum;
import org.apache.hive.org.apache.thrift.annotation.Nullable;
import org.apache.hive.org.apache.thrift.meta_data.FieldMetaData;
import org.apache.hive.org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.hive.org.apache.thrift.meta_data.ListMetaData;
import org.apache.hive.org.apache.thrift.protocol.TCompactProtocol;
import org.apache.hive.org.apache.thrift.protocol.TField;
import org.apache.hive.org.apache.thrift.protocol.TList;
import org.apache.hive.org.apache.thrift.protocol.TProtocol;
import org.apache.hive.org.apache.thrift.protocol.TProtocolException;
import org.apache.hive.org.apache.thrift.protocol.TProtocolUtil;
import org.apache.hive.org.apache.thrift.protocol.TStruct;
import org.apache.hive.org.apache.thrift.protocol.TTupleProtocol;
import org.apache.hive.org.apache.thrift.scheme.IScheme;
import org.apache.hive.org.apache.thrift.scheme.SchemeFactory;
import org.apache.hive.org.apache.thrift.scheme.StandardScheme;
import org.apache.hive.org.apache.thrift.scheme.TupleScheme;
import org.apache.hive.org.apache.thrift.transport.TIOStreamTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableValidWriteIds
implements TBase<TableValidWriteIds, _Fields>,
Serializable,
Cloneable,
Comparable<TableValidWriteIds> {
    private static final TStruct STRUCT_DESC = new TStruct("TableValidWriteIds");
    private static final TField FULL_TABLE_NAME_FIELD_DESC = new TField("fullTableName", 11, 1);
    private static final TField WRITE_ID_HIGH_WATER_MARK_FIELD_DESC = new TField("writeIdHighWaterMark", 10, 2);
    private static final TField INVALID_WRITE_IDS_FIELD_DESC = new TField("invalidWriteIds", 15, 3);
    private static final TField MIN_OPEN_WRITE_ID_FIELD_DESC = new TField("minOpenWriteId", 10, 4);
    private static final TField ABORTED_BITS_FIELD_DESC = new TField("abortedBits", 11, 5);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TableValidWriteIdsStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TableValidWriteIdsTupleSchemeFactory();
    @Nullable
    private String fullTableName;
    private long writeIdHighWaterMark;
    @Nullable
    private List<Long> invalidWriteIds;
    private long minOpenWriteId;
    @Nullable
    private ByteBuffer abortedBits;
    private static final int __WRITEIDHIGHWATERMARK_ISSET_ID = 0;
    private static final int __MINOPENWRITEID_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.MIN_OPEN_WRITE_ID};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TableValidWriteIds() {
    }

    public TableValidWriteIds(String fullTableName, long writeIdHighWaterMark, List<Long> invalidWriteIds, ByteBuffer abortedBits) {
        this();
        this.fullTableName = fullTableName;
        this.writeIdHighWaterMark = writeIdHighWaterMark;
        this.setWriteIdHighWaterMarkIsSet(true);
        this.invalidWriteIds = invalidWriteIds;
        this.abortedBits = TBaseHelper.copyBinary(abortedBits);
    }

    public TableValidWriteIds(TableValidWriteIds other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetFullTableName()) {
            this.fullTableName = other.fullTableName;
        }
        this.writeIdHighWaterMark = other.writeIdHighWaterMark;
        if (other.isSetInvalidWriteIds()) {
            ArrayList<Long> __this__invalidWriteIds = new ArrayList<Long>(other.invalidWriteIds);
            this.invalidWriteIds = __this__invalidWriteIds;
        }
        this.minOpenWriteId = other.minOpenWriteId;
        if (other.isSetAbortedBits()) {
            this.abortedBits = TBaseHelper.copyBinary(other.abortedBits);
        }
    }

    @Override
    public TableValidWriteIds deepCopy() {
        return new TableValidWriteIds(this);
    }

    @Override
    public void clear() {
        this.fullTableName = null;
        this.setWriteIdHighWaterMarkIsSet(false);
        this.writeIdHighWaterMark = 0L;
        this.invalidWriteIds = null;
        this.setMinOpenWriteIdIsSet(false);
        this.minOpenWriteId = 0L;
        this.abortedBits = null;
    }

    @Nullable
    public String getFullTableName() {
        return this.fullTableName;
    }

    public void setFullTableName(@Nullable String fullTableName) {
        this.fullTableName = fullTableName;
    }

    public void unsetFullTableName() {
        this.fullTableName = null;
    }

    public boolean isSetFullTableName() {
        return this.fullTableName != null;
    }

    public void setFullTableNameIsSet(boolean value) {
        if (!value) {
            this.fullTableName = null;
        }
    }

    public long getWriteIdHighWaterMark() {
        return this.writeIdHighWaterMark;
    }

    public void setWriteIdHighWaterMark(long writeIdHighWaterMark) {
        this.writeIdHighWaterMark = writeIdHighWaterMark;
        this.setWriteIdHighWaterMarkIsSet(true);
    }

    public void unsetWriteIdHighWaterMark() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetWriteIdHighWaterMark() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setWriteIdHighWaterMarkIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getInvalidWriteIdsSize() {
        return this.invalidWriteIds == null ? 0 : this.invalidWriteIds.size();
    }

    @Nullable
    public Iterator<Long> getInvalidWriteIdsIterator() {
        return this.invalidWriteIds == null ? null : this.invalidWriteIds.iterator();
    }

    public void addToInvalidWriteIds(long elem) {
        if (this.invalidWriteIds == null) {
            this.invalidWriteIds = new ArrayList<Long>();
        }
        this.invalidWriteIds.add(elem);
    }

    @Nullable
    public List<Long> getInvalidWriteIds() {
        return this.invalidWriteIds;
    }

    public void setInvalidWriteIds(@Nullable List<Long> invalidWriteIds) {
        this.invalidWriteIds = invalidWriteIds;
    }

    public void unsetInvalidWriteIds() {
        this.invalidWriteIds = null;
    }

    public boolean isSetInvalidWriteIds() {
        return this.invalidWriteIds != null;
    }

    public void setInvalidWriteIdsIsSet(boolean value) {
        if (!value) {
            this.invalidWriteIds = null;
        }
    }

    public long getMinOpenWriteId() {
        return this.minOpenWriteId;
    }

    public void setMinOpenWriteId(long minOpenWriteId) {
        this.minOpenWriteId = minOpenWriteId;
        this.setMinOpenWriteIdIsSet(true);
    }

    public void unsetMinOpenWriteId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetMinOpenWriteId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setMinOpenWriteIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public byte[] getAbortedBits() {
        this.setAbortedBits(TBaseHelper.rightSize(this.abortedBits));
        return this.abortedBits == null ? null : this.abortedBits.array();
    }

    public ByteBuffer bufferForAbortedBits() {
        return TBaseHelper.copyBinary(this.abortedBits);
    }

    public void setAbortedBits(byte[] abortedBits) {
        this.abortedBits = abortedBits == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])abortedBits.clone());
    }

    public void setAbortedBits(@Nullable ByteBuffer abortedBits) {
        this.abortedBits = TBaseHelper.copyBinary(abortedBits);
    }

    public void unsetAbortedBits() {
        this.abortedBits = null;
    }

    public boolean isSetAbortedBits() {
        return this.abortedBits != null;
    }

    public void setAbortedBitsIsSet(boolean value) {
        if (!value) {
            this.abortedBits = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetFullTableName();
                    break;
                }
                this.setFullTableName((String)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetWriteIdHighWaterMark();
                    break;
                }
                this.setWriteIdHighWaterMark((Long)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetInvalidWriteIds();
                    break;
                }
                this.setInvalidWriteIds((List)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetMinOpenWriteId();
                    break;
                }
                this.setMinOpenWriteId((Long)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetAbortedBits();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setAbortedBits((byte[])value);
                    break;
                }
                this.setAbortedBits((ByteBuffer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.getFullTableName();
            }
            case 1: {
                return this.getWriteIdHighWaterMark();
            }
            case 2: {
                return this.getInvalidWriteIds();
            }
            case 3: {
                return this.getMinOpenWriteId();
            }
            case 4: {
                return this.getAbortedBits();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetFullTableName();
            }
            case 1: {
                return this.isSetWriteIdHighWaterMark();
            }
            case 2: {
                return this.isSetInvalidWriteIds();
            }
            case 3: {
                return this.isSetMinOpenWriteId();
            }
            case 4: {
                return this.isSetAbortedBits();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TableValidWriteIds) {
            return this.equals((TableValidWriteIds)that);
        }
        return false;
    }

    public boolean equals(TableValidWriteIds that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_fullTableName = this.isSetFullTableName();
        boolean that_present_fullTableName = that.isSetFullTableName();
        if (this_present_fullTableName || that_present_fullTableName) {
            if (!this_present_fullTableName || !that_present_fullTableName) {
                return false;
            }
            if (!this.fullTableName.equals(that.fullTableName)) {
                return false;
            }
        }
        boolean this_present_writeIdHighWaterMark = true;
        boolean that_present_writeIdHighWaterMark = true;
        if (this_present_writeIdHighWaterMark || that_present_writeIdHighWaterMark) {
            if (!this_present_writeIdHighWaterMark || !that_present_writeIdHighWaterMark) {
                return false;
            }
            if (this.writeIdHighWaterMark != that.writeIdHighWaterMark) {
                return false;
            }
        }
        boolean this_present_invalidWriteIds = this.isSetInvalidWriteIds();
        boolean that_present_invalidWriteIds = that.isSetInvalidWriteIds();
        if (this_present_invalidWriteIds || that_present_invalidWriteIds) {
            if (!this_present_invalidWriteIds || !that_present_invalidWriteIds) {
                return false;
            }
            if (!this.invalidWriteIds.equals(that.invalidWriteIds)) {
                return false;
            }
        }
        boolean this_present_minOpenWriteId = this.isSetMinOpenWriteId();
        boolean that_present_minOpenWriteId = that.isSetMinOpenWriteId();
        if (this_present_minOpenWriteId || that_present_minOpenWriteId) {
            if (!this_present_minOpenWriteId || !that_present_minOpenWriteId) {
                return false;
            }
            if (this.minOpenWriteId != that.minOpenWriteId) {
                return false;
            }
        }
        boolean this_present_abortedBits = this.isSetAbortedBits();
        boolean that_present_abortedBits = that.isSetAbortedBits();
        if (this_present_abortedBits || that_present_abortedBits) {
            if (!this_present_abortedBits || !that_present_abortedBits) {
                return false;
            }
            if (!this.abortedBits.equals(that.abortedBits)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetFullTableName() ? 131071 : 524287);
        if (this.isSetFullTableName()) {
            hashCode = hashCode * 8191 + this.fullTableName.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.writeIdHighWaterMark);
        hashCode = hashCode * 8191 + (this.isSetInvalidWriteIds() ? 131071 : 524287);
        if (this.isSetInvalidWriteIds()) {
            hashCode = hashCode * 8191 + this.invalidWriteIds.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMinOpenWriteId() ? 131071 : 524287);
        if (this.isSetMinOpenWriteId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.minOpenWriteId);
        }
        hashCode = hashCode * 8191 + (this.isSetAbortedBits() ? 131071 : 524287);
        if (this.isSetAbortedBits()) {
            hashCode = hashCode * 8191 + this.abortedBits.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TableValidWriteIds other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetFullTableName(), other.isSetFullTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFullTableName() && (lastComparison = TBaseHelper.compareTo(this.fullTableName, other.fullTableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetWriteIdHighWaterMark(), other.isSetWriteIdHighWaterMark());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteIdHighWaterMark() && (lastComparison = TBaseHelper.compareTo(this.writeIdHighWaterMark, other.writeIdHighWaterMark)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetInvalidWriteIds(), other.isSetInvalidWriteIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInvalidWriteIds() && (lastComparison = TBaseHelper.compareTo(this.invalidWriteIds, other.invalidWriteIds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMinOpenWriteId(), other.isSetMinOpenWriteId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMinOpenWriteId() && (lastComparison = TBaseHelper.compareTo(this.minOpenWriteId, other.minOpenWriteId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAbortedBits(), other.isSetAbortedBits());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAbortedBits() && (lastComparison = TBaseHelper.compareTo(this.abortedBits, other.abortedBits)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TableValidWriteIds.scheme(iprot).read(iprot, (TableValidWriteIds)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TableValidWriteIds.scheme(oprot).write(oprot, (TableValidWriteIds)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TableValidWriteIds(");
        boolean first = true;
        sb.append("fullTableName:");
        if (this.fullTableName == null) {
            sb.append("null");
        } else {
            sb.append(this.fullTableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("writeIdHighWaterMark:");
        sb.append(this.writeIdHighWaterMark);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("invalidWriteIds:");
        if (this.invalidWriteIds == null) {
            sb.append("null");
        } else {
            sb.append(this.invalidWriteIds);
        }
        first = false;
        if (this.isSetMinOpenWriteId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("minOpenWriteId:");
            sb.append(this.minOpenWriteId);
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("abortedBits:");
        if (this.abortedBits == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString(this.abortedBits, sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetFullTableName()) {
            throw new TProtocolException("Required field 'fullTableName' is unset! Struct:" + this.toString());
        }
        if (!this.isSetWriteIdHighWaterMark()) {
            throw new TProtocolException("Required field 'writeIdHighWaterMark' is unset! Struct:" + this.toString());
        }
        if (!this.isSetInvalidWriteIds()) {
            throw new TProtocolException("Required field 'invalidWriteIds' is unset! Struct:" + this.toString());
        }
        if (!this.isSetAbortedBits()) {
            throw new TProtocolException("Required field 'abortedBits' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FULL_TABLE_NAME, new FieldMetaData("fullTableName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WRITE_ID_HIGH_WATER_MARK, new FieldMetaData("writeIdHighWaterMark", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INVALID_WRITE_IDS, new FieldMetaData("invalidWriteIds", 1, new ListMetaData(15, new FieldValueMetaData(10))));
        tmpMap.put(_Fields.MIN_OPEN_WRITE_ID, new FieldMetaData("minOpenWriteId", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ABORTED_BITS, new FieldMetaData("abortedBits", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TableValidWriteIds.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FULL_TABLE_NAME(1, "fullTableName"),
        WRITE_ID_HIGH_WATER_MARK(2, "writeIdHighWaterMark"),
        INVALID_WRITE_IDS(3, "invalidWriteIds"),
        MIN_OPEN_WRITE_ID(4, "minOpenWriteId"),
        ABORTED_BITS(5, "abortedBits");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FULL_TABLE_NAME;
                }
                case 2: {
                    return WRITE_ID_HIGH_WATER_MARK;
                }
                case 3: {
                    return INVALID_WRITE_IDS;
                }
                case 4: {
                    return MIN_OPEN_WRITE_ID;
                }
                case 5: {
                    return ABORTED_BITS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TableValidWriteIdsStandardSchemeFactory
    implements SchemeFactory {
        private TableValidWriteIdsStandardSchemeFactory() {
        }

        public TableValidWriteIdsStandardScheme getScheme() {
            return new TableValidWriteIdsStandardScheme();
        }
    }

    private static class TableValidWriteIdsTupleSchemeFactory
    implements SchemeFactory {
        private TableValidWriteIdsTupleSchemeFactory() {
        }

        public TableValidWriteIdsTupleScheme getScheme() {
            return new TableValidWriteIdsTupleScheme();
        }
    }

    private static class TableValidWriteIdsTupleScheme
    extends TupleScheme<TableValidWriteIds> {
        private TableValidWriteIdsTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TableValidWriteIds struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.fullTableName);
            oprot.writeI64(struct.writeIdHighWaterMark);
            oprot.writeI32(struct.invalidWriteIds.size());
            for (long _iter866 : struct.invalidWriteIds) {
                oprot.writeI64(_iter866);
            }
            oprot.writeBinary(struct.abortedBits);
            BitSet optionals = new BitSet();
            if (struct.isSetMinOpenWriteId()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetMinOpenWriteId()) {
                oprot.writeI64(struct.minOpenWriteId);
            }
        }

        @Override
        public void read(TProtocol prot, TableValidWriteIds struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.fullTableName = iprot.readString();
            struct.setFullTableNameIsSet(true);
            struct.writeIdHighWaterMark = iprot.readI64();
            struct.setWriteIdHighWaterMarkIsSet(true);
            TList _list867 = iprot.readListBegin((byte)10);
            struct.invalidWriteIds = new ArrayList<Long>(_list867.size);
            for (int _i869 = 0; _i869 < _list867.size; ++_i869) {
                long _elem868 = iprot.readI64();
                struct.invalidWriteIds.add(_elem868);
            }
            struct.setInvalidWriteIdsIsSet(true);
            struct.abortedBits = iprot.readBinary();
            struct.setAbortedBitsIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                struct.minOpenWriteId = iprot.readI64();
                struct.setMinOpenWriteIdIsSet(true);
            }
        }
    }

    private static class TableValidWriteIdsStandardScheme
    extends StandardScheme<TableValidWriteIds> {
        private TableValidWriteIdsStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TableValidWriteIds struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.fullTableName = iprot.readString();
                            struct.setFullTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.writeIdHighWaterMark = iprot.readI64();
                            struct.setWriteIdHighWaterMarkIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list862 = iprot.readListBegin();
                            struct.invalidWriteIds = new ArrayList<Long>(_list862.size);
                            for (int _i864 = 0; _i864 < _list862.size; ++_i864) {
                                long _elem863 = iprot.readI64();
                                struct.invalidWriteIds.add(_elem863);
                            }
                            iprot.readListEnd();
                            struct.setInvalidWriteIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.minOpenWriteId = iprot.readI64();
                            struct.setMinOpenWriteIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.abortedBits = iprot.readBinary();
                            struct.setAbortedBitsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TableValidWriteIds struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.fullTableName != null) {
                oprot.writeFieldBegin(FULL_TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.fullTableName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(WRITE_ID_HIGH_WATER_MARK_FIELD_DESC);
            oprot.writeI64(struct.writeIdHighWaterMark);
            oprot.writeFieldEnd();
            if (struct.invalidWriteIds != null) {
                oprot.writeFieldBegin(INVALID_WRITE_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.invalidWriteIds.size()));
                for (long _iter865 : struct.invalidWriteIds) {
                    oprot.writeI64(_iter865);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetMinOpenWriteId()) {
                oprot.writeFieldBegin(MIN_OPEN_WRITE_ID_FIELD_DESC);
                oprot.writeI64(struct.minOpenWriteId);
                oprot.writeFieldEnd();
            }
            if (struct.abortedBits != null) {
                oprot.writeFieldBegin(ABORTED_BITS_FIELD_DESC);
                oprot.writeBinary(struct.abortedBits);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

