/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.ql.ErrorMsg;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HiveException
extends Exception {
    private ErrorMsg canonicalErrorMsg = ErrorMsg.GENERIC_ERROR;
    private String remoteErrorMsg;

    public HiveException() {
    }

    public HiveException(String message) {
        super(message);
    }

    public HiveException(Throwable cause) {
        super(cause);
    }

    public HiveException(String message, Throwable cause) {
        super(message, cause);
    }

    public HiveException(ErrorMsg message, String ... msgArgs) {
        this(null, null, message, msgArgs);
    }

    public HiveException(Throwable cause, ErrorMsg errorMsg, String ... msgArgs) {
        this(cause, null, errorMsg, msgArgs);
    }

    public HiveException(Throwable cause, ErrorMsg errorMsg) {
        this(cause, null, errorMsg, new String[0]);
    }

    public HiveException(ErrorMsg errorMsg) {
        this(null, null, errorMsg, new String[0]);
    }

    public HiveException(Throwable cause, String remErrMsg, ErrorMsg errorMsg, String ... msgArgs) {
        super(errorMsg.format(msgArgs), cause);
        this.canonicalErrorMsg = errorMsg;
        this.remoteErrorMsg = remErrMsg;
    }

    public ErrorMsg getCanonicalErrorMsg() {
        return this.canonicalErrorMsg;
    }

    public String getRemoteErrorMsg() {
        return this.remoteErrorMsg;
    }
}

