/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.wrappedio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BulkDelete;
import org.apache.hadoop.fs.ByteBufferPositionedReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathCapabilities;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.util.functional.FunctionalIO;
import org.apache.hadoop.util.functional.FutureIO;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class WrappedIO {
    private WrappedIO() {
    }

    public static int bulkDelete_pageSize(FileSystem fs, Path path) {
        return (Integer)FunctionalIO.uncheckIOExceptions(() -> {
            try (BulkDelete bulk = fs.createBulkDelete(path);){
                Integer n = bulk.pageSize();
                return n;
            }
        });
    }

    public static List<Map.Entry<Path, String>> bulkDelete_delete(FileSystem fs, Path base, Collection<Path> paths) {
        return (List)FunctionalIO.uncheckIOExceptions(() -> {
            try (BulkDelete bulk = fs.createBulkDelete(base);){
                List<Map.Entry<Path, String>> list = bulk.bulkDelete(paths);
                return list;
            }
        });
    }

    public static boolean pathCapabilities_hasPathCapability(Object fs, Path path, String capability) {
        try {
            return ((PathCapabilities)fs).hasPathCapability(path, capability);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean streamCapabilities_hasCapability(Object object, String capability) {
        if (!(object instanceof StreamCapabilities)) {
            return false;
        }
        return ((StreamCapabilities)object).hasCapability(capability);
    }

    @InterfaceStability.Stable
    public static FSDataInputStream fileSystem_openFile(FileSystem fs, Path path, String policy, @Nullable FileStatus status, @Nullable Long length, @Nullable Map<String, String> options) {
        FutureDataInputStreamBuilder builder = (FutureDataInputStreamBuilder)FunctionalIO.uncheckIOExceptions(() -> fs.openFile(path));
        if (policy != null) {
            builder.opt("fs.option.openfile.read.policy", policy);
        }
        if (status != null) {
            builder.withFileStatus(status);
        }
        if (length != null) {
            builder.opt("fs.option.openfile.length", Long.toString(length));
        }
        if (options != null) {
            options.forEach(builder::opt);
        }
        return (FSDataInputStream)FunctionalIO.uncheckIOExceptions(() -> (FSDataInputStream)FutureIO.awaitFuture((Future)builder.build()));
    }

    public static Path fileSystem_getEnclosingRoot(FileSystem fs, Path path) throws IOException {
        return fs.getEnclosingRoot(path);
    }

    public static void byteBufferPositionedReadable_readFully(InputStream in, long position, ByteBuffer buf) {
        if (!(in instanceof ByteBufferPositionedReadable)) {
            throw new UnsupportedOperationException("Not a ByteBufferPositionedReadable: " + in);
        }
        FunctionalIO.uncheckIOExceptions(() -> {
            ((ByteBufferPositionedReadable)((Object)in)).readFully(position, buf);
            return null;
        });
    }

    public static boolean byteBufferPositionedReadable_readFullyAvailable(InputStream in) {
        if (!(in instanceof ByteBufferPositionedReadable)) {
            return false;
        }
        if (in instanceof FSDataInputStream) {
            return WrappedIO.byteBufferPositionedReadable_readFullyAvailable(((FSDataInputStream)in).getWrappedStream());
        }
        return WrappedIO.streamCapabilities_hasCapability(in, "in:preadbytebuffer");
    }
}

