/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;

public class DelegationTokenLoadingCache<K, V>
implements Map<K, V> {
    private LoadingCache<K, V> internalLoadingCache;

    public DelegationTokenLoadingCache(long cacheExpirationMs, long maximumCacheSize, final Function<K, V> singleEntryFunction) {
        this.internalLoadingCache = CacheBuilder.newBuilder().expireAfterWrite(cacheExpirationMs, TimeUnit.MILLISECONDS).maximumSize(maximumCacheSize).build(new CacheLoader<K, V>(){

            @Override
            public V load(K k) throws Exception {
                return singleEntryFunction.apply(k);
            }
        });
    }

    @Override
    public int size() {
        return (int)this.internalLoadingCache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalLoadingCache.getIfPresent(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        try {
            return this.internalLoadingCache.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public V put(K key, V value) {
        this.internalLoadingCache.put(key, value);
        return this.internalLoadingCache.getIfPresent(key);
    }

    @Override
    public V remove(Object key) {
        Object value = this.internalLoadingCache.getIfPresent(key);
        this.internalLoadingCache.invalidate(key);
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.internalLoadingCache.putAll(m4);
    }

    @Override
    public void clear() {
        this.internalLoadingCache.invalidateAll();
    }

    @Override
    public Set<K> keySet() {
        return this.internalLoadingCache.asMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.internalLoadingCache.asMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalLoadingCache.asMap().entrySet();
    }
}

