/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public enum SignalLogger {
    INSTANCE;

    private boolean registered = false;

    public void register(Logger log) {
        if (this.registered) {
            throw new IllegalStateException("Can't re-install the signal handlers.");
        }
        this.registered = true;
        StringBuilder bld = new StringBuilder();
        bld.append("registered UNIX signal handlers for [");
        String[] SIGNALS = new String[]{"TERM", "HUP", "INT"};
        String separator = "";
        for (String signalName : SIGNALS) {
            try {
                new Handler(signalName, log);
                bld.append(separator).append(signalName);
                separator = ", ";
            }
            catch (Exception e) {
                log.debug("Error: ", e);
            }
        }
        bld.append("]");
        log.info(bld.toString());
    }

    private static class Handler
    implements SignalHandler {
        private final Logger log;
        private final SignalHandler prevHandler;

        Handler(String name, Logger log) {
            this.log = log;
            this.prevHandler = Signal.handle(new Signal(name), this);
        }

        @Override
        public void handle(Signal signal) {
            this.log.error("RECEIVED SIGNAL " + signal.getNumber() + ": SIG" + signal.getName());
            this.prevHandler.handle(signal);
        }
    }
}

