/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.net.URL;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.hplsql.Exec;

public class Conf
extends Configuration {
    public static final String SITE_XML = "hplsql-site.xml";
    public static final String DOT_HPLSQLRC = ".hplsqlrc";
    public static final String HPLSQLRC = "hplsqlrc";
    public static final String HPLSQL_LOCALS_SQL = "hplsql_locals.sql";
    public static final String CONN_CONVERT = "hplsql.conn.convert.";
    public static final String CONN_DEFAULT = "hplsql.conn.default";
    public static final String DUAL_TABLE = "hplsql.dual.table";
    public static final String INSERT_VALUES = "hplsql.insert.values";
    public static final String ONERROR = "hplsql.onerror";
    public static final String TEMP_TABLES = "hplsql.temp.tables";
    public static final String TEMP_TABLES_SCHEMA = "hplsql.temp.tables.schema";
    public static final String TEMP_TABLES_LOCATION = "hplsql.temp.tables.location";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String YES = "yes";
    public static final String NO = "no";
    public String defaultConnection;
    Exec.OnError onError = Exec.OnError.EXCEPTION;
    InsertValues insertValues = InsertValues.NATIVE;
    TempTables tempTables = TempTables.NATIVE;
    String dualTable = null;
    String tempTablesSchema = "";
    String tempTablesLocation = "/tmp/hplsql";
    HashMap<String, Boolean> connConvert = new HashMap();

    public void setOption(String key, String value) {
        if (key.startsWith(CONN_CONVERT)) {
            this.setConnectionConvert(key.substring(19), value);
        } else if (key.compareToIgnoreCase(CONN_DEFAULT) == 0) {
            this.defaultConnection = value;
        } else if (key.compareToIgnoreCase(DUAL_TABLE) == 0) {
            this.dualTable = value;
        } else if (key.compareToIgnoreCase(INSERT_VALUES) == 0) {
            this.setInsertValues(value);
        } else if (key.compareToIgnoreCase(ONERROR) == 0) {
            this.setOnError(value);
        } else if (key.compareToIgnoreCase(TEMP_TABLES) == 0) {
            this.setTempTables(value);
        } else if (key.compareToIgnoreCase(TEMP_TABLES_SCHEMA) == 0) {
            this.tempTablesSchema = value;
        } else if (key.compareToIgnoreCase(TEMP_TABLES_LOCATION) == 0) {
            this.tempTablesLocation = value;
        }
    }

    private void setInsertValues(String value) {
        if (value.compareToIgnoreCase("NATIVE") == 0) {
            this.insertValues = InsertValues.NATIVE;
        } else if (value.compareToIgnoreCase("SELECT") == 0) {
            this.insertValues = InsertValues.SELECT;
        }
    }

    private void setTempTables(String value) {
        if (value.compareToIgnoreCase("NATIVE") == 0) {
            this.tempTables = TempTables.NATIVE;
        } else if (value.compareToIgnoreCase("MANAGED") == 0) {
            this.tempTables = TempTables.MANAGED;
        }
    }

    private void setOnError(String value) {
        if (value.compareToIgnoreCase("EXCEPTION") == 0) {
            this.onError = Exec.OnError.EXCEPTION;
        } else if (value.compareToIgnoreCase("SETERROR") == 0) {
            this.onError = Exec.OnError.SETERROR;
        }
        if (value.compareToIgnoreCase("STOP") == 0) {
            this.onError = Exec.OnError.STOP;
        }
    }

    void setConnectionConvert(String name, String value) {
        boolean convert = false;
        if (value.compareToIgnoreCase(TRUE) == 0 || value.compareToIgnoreCase(YES) == 0) {
            convert = true;
        }
        this.connConvert.put(name, convert);
    }

    boolean getConnectionConvert(String name) {
        Boolean convert = this.connConvert.get(name);
        if (convert != null) {
            return convert;
        }
        return false;
    }

    public void init() {
        this.addResource(SITE_XML);
    }

    public String getLocation() {
        URL url = this.getResource(SITE_XML);
        if (url != null) {
            return url.toString();
        }
        return "";
    }

    public static enum InsertValues {
        NATIVE,
        SELECT;

    }

    public static enum TempTables {
        NATIVE,
        MANAGED;

    }
}

