/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.saml;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.com.google.common.base.Predicate;
import org.apache.hive.com.google.common.base.Splitter;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.pac4j.saml.credentials.SAML2Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSamlGroupNameFilter
implements Predicate<SAML2Credentials.SAMLAttribute> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveSamlGroupNameFilter.class);
    private final List<String> groupNames;
    private static final Splitter COMMA_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private final String attributeName;

    public HiveSamlGroupNameFilter(HiveConf conf) {
        String groupNameStr = conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_GROUP_FILTER.varname);
        this.attributeName = conf.get(HiveConf.ConfVars.HIVE_SERVER2_SAML_GROUP_ATTRIBUTE_NAME.varname, "");
        ImmutableList.Builder builder = ImmutableList.builder();
        if (groupNameStr != null && !groupNameStr.isEmpty()) {
            builder.addAll(COMMA_SPLITTER.split(groupNameStr));
        }
        this.groupNames = builder.build();
    }

    @Override
    public boolean apply(List<SAML2Credentials.SAMLAttribute> attributes) {
        if (this.attributeName.isEmpty() && attributes.size() == 0) {
            return true;
        }
        for (SAML2Credentials.SAMLAttribute attribute : attributes) {
            if (!this.apply(attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(SAML2Credentials.SAMLAttribute attribute) {
        if (this.attributeName.isEmpty()) {
            return true;
        }
        if (attribute == null || attribute.getName() == null) {
            return false;
        }
        if (!this.attributeName.equals(attribute.getName())) {
            return false;
        }
        for (String attrVal : attribute.getAttributeValues()) {
            if (!this.groupNames.contains(attrVal)) continue;
            return true;
        }
        return false;
    }
}

