/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="SketchToString", value="_FUNC_(sketch, seed)", extended="Returns a human-readable summary of a given CpcSketch.")
public class SketchToStringUDF
extends UDF {
    public String evaluate(BytesWritable serializedSketch, long seed) {
        if (serializedSketch == null) {
            return null;
        }
        CpcSketch sketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), (long)seed);
        return sketch.toString();
    }

    public String evaluate(BytesWritable serializedSketch) {
        return this.evaluate(serializedSketch, 9001L);
    }
}

