/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="DoubleSummarySketchToEstimates", value="_FUNC_(sketch)", extended="Returns a list of estimates from a given Sketch<DoubleSummary>. The result will be two double values. The first estimate is the estimate of the number of unique keys in the original population. Next there is an estimate of the sum of the parameter in the original population (sum of the values in the sketch scaled to the original population. This estimate assumes that the DoubleSummary was used in the Sum mode.)")
public class DoubleSummarySketchToEstimatesUDF
extends UDF {
    private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();

    public List<Double> evaluate(BytesWritable serializedSketch) {
        if (serializedSketch == null) {
            return null;
        }
        Sketch sketch = Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), SUMMARY_DESERIALIZER);
        double sum = 0.0;
        TupleSketchIterator it = sketch.iterator();
        while (it.next()) {
            sum += ((DoubleSummary)it.getSummary()).getValue();
        }
        return Arrays.asList(sketch.getEstimate(), sum / sketch.getTheta());
    }
}

