/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hive.metastore.properties.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationProxy<T extends Serializable>
implements Externalizable {
    private static final long serialVersionUID = 202212281757L;
    public static final Logger LOGGER = LoggerFactory.getLogger(SerializationProxy.class);
    private static final ConcurrentMap<String, Type<?>> TYPES = new ConcurrentHashMap();
    private static final List<Type<?>> REGISTERED = new ArrayList();
    private static final ThreadLocal<Object[]> EXTRA_ARGUMENTS = new ThreadLocal();
    private transient Type<T> type = null;
    private transient T proxied = null;

    public SerializationProxy(T proxify) {
        Class<?> clazz = proxify.getClass();
        this.type = TYPES.computeIfAbsent(clazz.getName(), this::createType);
        this.proxied = proxify;
    }

    public SerializationProxy() {
    }

    public static void setExtraArguments(Object[] o) {
        if (null == o) {
            EXTRA_ARGUMENTS.remove();
        } else {
            EXTRA_ARGUMENTS.set(o);
        }
    }

    public static Object[] getExtraArguments() {
        return EXTRA_ARGUMENTS.get();
    }

    public static Object[] swapExtraArguments(Object[] newArgs) {
        Object[] previous = EXTRA_ARGUMENTS.get();
        SerializationProxy.setExtraArguments(newArgs);
        return previous;
    }

    public static void unload() {
        EXTRA_ARGUMENTS.remove();
        TYPES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void registerType(int slot, Class<T> clazz) {
        List<Type<?>> list = REGISTERED;
        synchronized (list) {
            Type<T> ntype = new Type<T>(clazz);
            ntype.slot = slot;
            if (slot >= 255) {
                throw new IllegalArgumentException(String.valueOf(ntype) + "@" + slot + ": can not register more than 254 types");
            }
            List<Type<?>> types = REGISTERED;
            while (types.size() <= slot) {
                types.add(null);
            }
            if (types.get(slot) != null) {
                throw new IllegalArgumentException(String.valueOf(ntype) + "@" + slot + ": slot already used by " + String.valueOf(types.get(slot)));
            }
            types.set(slot, ntype);
            TYPES.put(clazz.getName(), ntype);
        }
    }

    public Object readResolve() throws IOException {
        return this.proxied;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        long serial = in.readLong();
        if (serial != 202212281757L) {
            throw new ProxyException("invalid serial version, got " + serial + ", expected 202212281757");
        }
        this.type = this.readType(in);
        this.proxied = this.type.proxyNew(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(202212281757L);
        this.writeType(this.type, out);
        this.type.proxyWrite(this.proxied, out);
    }

    public static byte[] toBytes(Serializable serializable, Object ... args) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(512);
        Object[] stack = SerializationProxy.swapExtraArguments(args);
        try {
            byte[] byArray;
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            try {
                oos.writeObject(serializable);
                oos.flush();
                byArray = bos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        oos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException xany) {
                    throw ProxyException.convert(xany);
                }
            }
            oos.close();
            return byArray;
        }
        finally {
            SerializationProxy.swapExtraArguments(stack);
        }
    }

    public static <T extends Serializable> T fromBytes(byte[] bytes, Object ... args) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        Object[] stack = SerializationProxy.swapExtraArguments(args);
        try {
            Serializable serializable;
            ObjectInputStream ois = new ObjectInputStream(bis);
            try {
                serializable = (Serializable)ois.readObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ois.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | ClassCastException | ClassNotFoundException xany) {
                    throw ProxyException.convert(xany);
                }
            }
            ois.close();
            return (T)serializable;
        }
        finally {
            SerializationProxy.swapExtraArguments(stack);
        }
    }

    public static boolean write(File file, Serializable persist, Object ... args) {
        return Serializer.SERIALIZER.write(file, persist, args);
    }

    public static boolean write(OutputStream out, Serializable persist, Object ... args) {
        return Serializer.SERIALIZER.write(out, persist, args);
    }

    public static Serializable read(File file, Object ... args) {
        return Serializer.SERIALIZER.read(file, args);
    }

    public static <T extends Serializable> T read(InputStream in, Object ... args) {
        return (T)Serializer.SERIALIZER.read(in, args);
    }

    protected Type<T> createType(String cname) {
        try {
            Class<?> clazz = Class.forName(cname);
            return new Type(clazz);
        }
        catch (ClassNotFoundException xnotfound) {
            throw ProxyException.convert(xnotfound);
        }
    }

    protected void writeType(Type<?> type, DataOutput out) throws IOException {
        int slot = type.getSlot();
        out.write(slot);
        if (slot == 255) {
            out.writeUTF(type.getTargetName());
        }
    }

    protected Type<T> readType(DataInput in) throws IOException {
        Type type;
        String className = "?";
        int slot = in.readByte() & 0xFF;
        if (slot == 255) {
            className = in.readUTF();
            type = TYPES.computeIfAbsent(className, this::createType);
        } else {
            type = slot < REGISTERED.size() ? REGISTERED.get(slot) : null;
        }
        if (type == null) {
            throw new ProxyException("can not resolve class @ " + slot + ", " + className);
        }
        return type;
    }

    protected static class Type<T extends Serializable> {
        private final Constructor<T>[] ctors;
        private final Method[] writes;
        private transient int slot = 255;
        private static final Map<Class<?>, List<Class<?>>> CONVERTIBLES = new HashMap(9);

        public Type(Class<T> clazz) {
            this.ctors = Type.typeConstructors(clazz);
            this.writes = Type.typeWrites(clazz);
        }

        public int getSlot() {
            return this.slot;
        }

        public String getTargetName() {
            return this.ctors[0].getDeclaringClass().getName();
        }

        private static int compareSignatures(Executable lhs, Executable rhs) {
            return Type.compareSignatures(lhs.getParameterTypes(), rhs.getParameterTypes());
        }

        private static int compareSignatures(Class<?>[] lhs, Class<?>[] rhs) {
            if (lhs.length < rhs.length) {
                return -1;
            }
            if (lhs.length > rhs.length) {
                return 1;
            }
            int cmp = 0;
            int length = lhs.length;
            for (int p = 0; p < length; ++p) {
                int dist;
                Class<?> actual = lhs[p];
                Class<?> formal = rhs[p];
                if (formal == null || actual == null || formal.isAssignableFrom(actual)) continue;
                if (formal.isPrimitive() && (dist = CONVERTIBLES.get(formal).indexOf(actual)) >= 0) {
                    cmp += dist;
                    continue;
                }
                dist = formal.getName().compareTo(actual.getName());
                if (dist == 0) continue;
                return dist * (length - p);
            }
            return cmp;
        }

        private static <T> Constructor<T>[] typeConstructors(Class<T> clazz) {
            Constructor<?>[] mctor = clazz.getConstructors();
            ArrayList keepers = new ArrayList(mctor.length);
            for (Constructor<?> kctor : mctor) {
                Class<?>[] parms = kctor.getParameterTypes();
                if (parms.length <= 0 || !DataInput.class.isAssignableFrom(parms[0])) continue;
                kctor.setAccessible(true);
                keepers.add(kctor);
            }
            if (keepers.isEmpty()) {
                throw new ProxyException(String.valueOf(clazz) + ": serialization proxy can not find suitable constructor");
            }
            Constructor[] kctors = keepers.toArray(new Constructor[0]);
            Arrays.sort(kctors, Type::compareSignatures);
            return kctors;
        }

        private static Method[] typeWrites(Class<?> clazz) {
            Method[] mwrites = clazz.getDeclaredMethods();
            ArrayList<Method> keepers = new ArrayList<Method>(mwrites.length);
            for (Method kwrite : mwrites) {
                Class<?>[] parms = kwrite.getParameterTypes();
                if (!"write".equals(kwrite.getName()) || parms.length <= 0 || !DataOutput.class.isAssignableFrom(parms[0])) continue;
                kwrite.setAccessible(true);
                keepers.add(kwrite);
            }
            if (keepers.isEmpty()) {
                throw new ProxyException(String.valueOf(clazz) + ": serialization proxy can not find suitable write method");
            }
            Method[] kwrites = keepers.toArray(new Method[0]);
            Arrays.sort(kwrites, Type::compareSignatures);
            return kwrites;
        }

        public T proxyNew(ObjectInput in) {
            Object[] arguments = SerializationProxy.swapExtraArguments(null);
            try {
                Object[] ctorArgs = Type.makeArgs(in, arguments);
                Constructor ctor = (Constructor)Type.findBest((Executable[])this.ctors, (Object[])ctorArgs);
                Serializable serializable = (Serializable)ctor.newInstance(ctorArgs);
                return (T)serializable;
            }
            catch (InvocationTargetException xinvoke) {
                Throwable xtarget = xinvoke.getTargetException();
                throw ProxyException.convert(xtarget != null ? xtarget : xinvoke);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException xany) {
                throw ProxyException.convert(xany);
            }
            finally {
                SerializationProxy.swapExtraArguments(arguments);
            }
        }

        public void proxyWrite(T proxy, ObjectOutput out) {
            Object[] arguments = SerializationProxy.swapExtraArguments(null);
            try {
                Object[] writeArgs = Type.makeArgs(out, arguments);
                Method write = (Method)Type.findBest((Executable[])this.writes, (Object[])writeArgs);
                write.invoke(proxy, writeArgs);
            }
            catch (InvocationTargetException xinvoke) {
                Throwable xtarget = xinvoke.getTargetException();
                throw ProxyException.convert(xtarget != null ? xtarget : xinvoke);
            }
            catch (IllegalAccessException | IllegalArgumentException xany) {
                throw ProxyException.convert(xany);
            }
            finally {
                SerializationProxy.swapExtraArguments(arguments);
            }
        }

        static Object[] makeArgs(Object stream, Object[] other) {
            if (other == null || other.length == 0) {
                return new Object[]{stream};
            }
            Object[] args = new Object[other.length + 1];
            args[0] = stream;
            System.arraycopy(other, 0, args, 1, other.length);
            return args;
        }

        private static <X extends Executable> X findBest(X[] candidates, Object[] args) {
            X exec = candidates[0];
            if (candidates.length > 1) {
                Class[] parameters = new Class[args.length];
                for (int c = 0; c < args.length; ++c) {
                    parameters[c] = args[c] == null ? null : args[c].getClass();
                }
                for (X candidate : candidates) {
                    if (Type.compareSignatures(parameters, ((Executable)candidate).getParameterTypes()) != 0) continue;
                    exec = candidate;
                    break;
                }
            }
            return exec;
        }

        static {
            CONVERTIBLES.put(Void.TYPE, Collections.emptyList());
            CONVERTIBLES.put(Boolean.TYPE, Collections.singletonList(Boolean.class));
            CONVERTIBLES.put(Character.TYPE, Collections.singletonList(Character.class));
            CONVERTIBLES.put(Byte.TYPE, Collections.singletonList(Byte.class));
            CONVERTIBLES.put(Short.TYPE, Arrays.asList(Short.class, Byte.class));
            CONVERTIBLES.put(Integer.TYPE, Arrays.asList(Integer.class, Short.class, Byte.class));
            CONVERTIBLES.put(Long.TYPE, Arrays.asList(Long.class, Integer.class, Short.class, Byte.class));
            CONVERTIBLES.put(Float.TYPE, Arrays.asList(Float.class, Long.class, Integer.class, Short.class, Byte.class));
            CONVERTIBLES.put(Double.TYPE, Arrays.asList(Double.class, Float.class, Long.class, Integer.class, Short.class, Byte.class));
        }
    }

    public static class ProxyException
    extends RuntimeException {
        public ProxyException(Throwable cause) {
            super(cause);
        }

        public ProxyException(String msg) {
            super(msg);
        }

        public static ProxyException convert(Throwable cause) {
            if (cause instanceof ProxyException) {
                return (ProxyException)cause;
            }
            return new ProxyException(cause);
        }
    }
}

