/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.Objects;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class SnapshotRef
implements Serializable {
    public static final String MAIN_BRANCH = "main";
    private final long snapshotId;
    private final SnapshotRefType type;
    private final Integer minSnapshotsToKeep;
    private final Long maxSnapshotAgeMs;
    private final Long maxRefAgeMs;

    private SnapshotRef(long snapshotId, SnapshotRefType type, Integer minSnapshotsToKeep, Long maxSnapshotAgeMs, Long maxRefAgeMs) {
        this.snapshotId = snapshotId;
        this.type = type;
        this.minSnapshotsToKeep = minSnapshotsToKeep;
        this.maxSnapshotAgeMs = maxSnapshotAgeMs;
        this.maxRefAgeMs = maxRefAgeMs;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public SnapshotRefType type() {
        return this.type;
    }

    public boolean isBranch() {
        return this.type == SnapshotRefType.BRANCH;
    }

    public boolean isTag() {
        return this.type == SnapshotRefType.TAG;
    }

    public Integer minSnapshotsToKeep() {
        return this.minSnapshotsToKeep;
    }

    public Long maxSnapshotAgeMs() {
        return this.maxSnapshotAgeMs;
    }

    public Long maxRefAgeMs() {
        return this.maxRefAgeMs;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SnapshotRef)) {
            return false;
        }
        SnapshotRef ref = (SnapshotRef)other;
        return ref.snapshotId == this.snapshotId && Objects.equals((Object)ref.type(), (Object)this.type) && Objects.equals(ref.maxRefAgeMs(), this.maxRefAgeMs) && Objects.equals(ref.minSnapshotsToKeep(), this.minSnapshotsToKeep) && Objects.equals(ref.maxSnapshotAgeMs(), this.maxSnapshotAgeMs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotId, this.type, this.maxRefAgeMs, this.maxSnapshotAgeMs, this.minSnapshotsToKeep});
    }

    public static Builder tagBuilder(long snapshotId) {
        return SnapshotRef.builderFor(snapshotId, SnapshotRefType.TAG);
    }

    public static Builder branchBuilder(long snapshotId) {
        return SnapshotRef.builderFor(snapshotId, SnapshotRefType.BRANCH);
    }

    public static Builder builderFrom(SnapshotRef ref) {
        return new Builder(ref.type(), ref.snapshotId()).minSnapshotsToKeep(ref.minSnapshotsToKeep()).maxSnapshotAgeMs(ref.maxSnapshotAgeMs()).maxRefAgeMs(ref.maxRefAgeMs());
    }

    public static Builder builderFrom(SnapshotRef ref, long snapshotId) {
        return new Builder(ref.type(), snapshotId).minSnapshotsToKeep(ref.minSnapshotsToKeep()).maxSnapshotAgeMs(ref.maxSnapshotAgeMs()).maxRefAgeMs(ref.maxRefAgeMs());
    }

    public static Builder builderFor(long snapshotId, SnapshotRefType type) {
        return new Builder(type, snapshotId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("snapshotId", this.snapshotId).add("type", (Object)this.type).add("minSnapshotsToKeep", this.minSnapshotsToKeep).add("maxSnapshotAgeMs", this.maxSnapshotAgeMs).add("maxRefAgeMs", this.maxRefAgeMs).toString();
    }

    public static class Builder {
        private final SnapshotRefType type;
        private final long snapshotId;
        private Integer minSnapshotsToKeep;
        private Long maxSnapshotAgeMs;
        private Long maxRefAgeMs;

        Builder(SnapshotRefType type, long snapshotId) {
            Preconditions.checkArgument(type != null, "Snapshot reference type must not be null");
            this.type = type;
            this.snapshotId = snapshotId;
        }

        public Builder minSnapshotsToKeep(Integer value) {
            Preconditions.checkArgument(value == null || !this.type.equals((Object)SnapshotRefType.TAG), "Tags do not support setting minSnapshotsToKeep");
            Preconditions.checkArgument(value == null || value > 0, "Min snapshots to keep must be greater than 0");
            this.minSnapshotsToKeep = value;
            return this;
        }

        public Builder maxSnapshotAgeMs(Long value) {
            Preconditions.checkArgument(value == null || !this.type.equals((Object)SnapshotRefType.TAG), "Tags do not support setting maxSnapshotAgeMs");
            Preconditions.checkArgument(value == null || value > 0L, "Max snapshot age must be greater than 0 ms");
            this.maxSnapshotAgeMs = value;
            return this;
        }

        public Builder maxRefAgeMs(Long value) {
            Preconditions.checkArgument(value == null || value > 0L, "Max reference age must be greater than 0");
            this.maxRefAgeMs = value;
            return this;
        }

        public SnapshotRef build() {
            return new SnapshotRef(this.snapshotId, this.type, this.minSnapshotsToKeep, this.maxSnapshotAgeMs, this.maxRefAgeMs);
        }
    }
}

