/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.List;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.ClusteredWriter;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingEqualityDeleteWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class ClusteredEqualityDeleteWriter<T>
extends ClusteredWriter<T, DeleteWriteResult> {
    private final FileWriterFactory<T> writerFactory;
    private final OutputFileFactory fileFactory;
    private final FileIO io;
    private final long targetFileSizeInBytes;
    private final List<DeleteFile> deleteFiles;

    public ClusteredEqualityDeleteWriter(FileWriterFactory<T> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSizeInBytes) {
        this.writerFactory = writerFactory;
        this.fileFactory = fileFactory;
        this.io = io;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.deleteFiles = Lists.newArrayList();
    }

    @Override
    protected FileWriter<T, DeleteWriteResult> newWriter(PartitionSpec spec, StructLike partition) {
        return new RollingEqualityDeleteWriter<T>(this.writerFactory, this.fileFactory, this.io, this.targetFileSizeInBytes, spec, partition);
    }

    @Override
    protected void addResult(DeleteWriteResult result) {
        Preconditions.checkArgument(!result.referencesDataFiles(), "Equality deletes cannot reference data files");
        this.deleteFiles.addAll(result.deleteFiles());
    }

    @Override
    protected DeleteWriteResult aggregatedResult() {
        return new DeleteWriteResult(this.deleteFiles);
    }
}

