/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.hive.ql.txn.compactor.TableOptimizer;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.hive.RuntimeMetaException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.compaction.evaluator.CompactionEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class IcebergTableOptimizer
extends TableOptimizer {
    private HiveMetaStoreClient client;
    private Map<String, Long> snapshotTimeMilCache;

    public IcebergTableOptimizer(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache) throws MetaException {
        super(conf, txnHandler, metadataCache);
        this.init();
    }

    public Set<CompactionInfo> findPotentialCompactions(long lastChecked, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) {
        HashSet<CompactionInfo> compactionTargets = Sets.newHashSet();
        Iterable<org.apache.hadoop.hive.metastore.api.Table> tables = this.getTables(skipDBs, skipTables);
        for (org.apache.hadoop.hive.metastore.api.Table table : tables) {
            String qualifiedTableName;
            org.apache.hadoop.hive.ql.metadata.Table hiveTable = new org.apache.hadoop.hive.ql.metadata.Table(table);
            Table icebergTable = IcebergTableUtil.getTable((Configuration)this.conf, table);
            if (!this.hasNewCommits(icebergTable, this.snapshotTimeMilCache.get(qualifiedTableName = hiveTable.getFullyQualifiedName()))) continue;
            if (icebergTable.spec().isPartitioned()) {
                List<Partition> partitions = this.findModifiedPartitions(hiveTable, icebergTable, this.snapshotTimeMilCache.get(qualifiedTableName), true);
                partitions.forEach(partition -> this.addCompactionTargetIfEligible(table, icebergTable, partition.getName(), compactionTargets, currentCompactions, skipDBs, skipTables));
                if (IcebergTableUtil.hasUndergonePartitionEvolution(icebergTable) && !this.findModifiedPartitions(hiveTable, icebergTable, this.snapshotTimeMilCache.get(qualifiedTableName), false).isEmpty()) {
                    this.addCompactionTargetIfEligible(table, icebergTable, null, compactionTargets, currentCompactions, skipDBs, skipTables);
                }
            } else {
                this.addCompactionTargetIfEligible(table, icebergTable, null, compactionTargets, currentCompactions, skipDBs, skipTables);
            }
            this.snapshotTimeMilCache.put(qualifiedTableName, icebergTable.currentSnapshot().timestampMillis());
        }
        return compactionTargets;
    }

    private Iterable<org.apache.hadoop.hive.metastore.api.Table> getTables(Set<String> skipDBs, Set<String> skipTables) {
        try {
            int maxBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            return IcebergTableUtil.getTableFetcher((IMetaStoreClient)this.client, null, "*", null).getTables(skipDBs, skipTables, maxBatchSize);
        }
        catch (Exception e) {
            throw new RuntimeMetaException(e, "Error getting tables", new Object[0]);
        }
    }

    public void init() throws MetaException {
        this.client = new HiveMetaStoreClient((Configuration)new HiveConf());
        this.snapshotTimeMilCache = Maps.newConcurrentMap();
    }

    private void addCompactionTargetIfEligible(org.apache.hadoop.hive.metastore.api.Table table, Table icebergTable, String partitionName, Set<CompactionInfo> compactions, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) {
        CompactionEvaluator compactionEvaluator;
        CompactionInfo ci = new CompactionInfo(table.getDbName(), table.getTableName(), partitionName, CompactionType.SMART_OPTIMIZE);
        if (!this.isEligibleForCompaction(ci, currentCompactions, skipDBs, skipTables)) {
            return;
        }
        try {
            compactionEvaluator = new CompactionEvaluator(icebergTable, ci, table.getParameters());
        }
        catch (IOException e) {
            throw new RuntimeMetaException(e, "Error construction compaction evaluator for table %s", table.getTableName());
        }
        if (!compactionEvaluator.isEligibleForCompaction()) {
            return;
        }
        ci.type = compactionEvaluator.determineCompactionType();
        compactions.add(ci);
    }

    private List<Partition> findModifiedPartitions(org.apache.hadoop.hive.ql.metadata.Table hiveTable, Table icebergTable, Long pastSnapshotTimeMil, Boolean latestSpecOnly) {
        List<Snapshot> relevantSnapshots = this.getRelevantSnapshots(icebergTable, pastSnapshotTimeMil).toList();
        if (relevantSnapshots.isEmpty()) {
            return Collections.emptyList();
        }
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        try {
            List<Future> futures = relevantSnapshots.stream().map(snapshot -> executor.submit(() -> {
                FileIO io = icebergTable.io();
                ImmutableList<DeleteFile> affectedFiles = FluentIterable.concat(snapshot.addedDataFiles(io), snapshot.removedDataFiles(io), snapshot.addedDeleteFiles(io), snapshot.removedDeleteFiles(io)).toList();
                return IcebergTableUtil.getPartitionNames(icebergTable, affectedFiles, latestSpecOnly);
            })).toList();
            HashSet<String> modifiedPartitions = Sets.newHashSet();
            for (Future future : futures) {
                modifiedPartitions.addAll((Collection)future.get());
            }
            List<Partition> list = IcebergTableUtil.convertNameToMetastorePartition(hiveTable, modifiedPartitions);
            if (executor != null) {
                executor.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (executor != null) {
                    try {
                        executor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeMetaException(e, "Interrupted while finding modified partitions", new Object[0]);
            }
            catch (ExecutionException e) {
                throw new RuntimeMetaException(e, "Failed to find modified partitions in parallel", new Object[0]);
            }
        }
    }

    private boolean hasNewCommits(Table icebergTable, Long pastSnapshotTimeMil) {
        return this.getRelevantSnapshots(icebergTable, pastSnapshotTimeMil).findAny().isPresent();
    }

    private Stream<Snapshot> getRelevantSnapshots(Table icebergTable, Long pastSnapshotTimeMil) {
        Snapshot currentSnapshot = icebergTable.currentSnapshot();
        if (currentSnapshot == null || Objects.equals(currentSnapshot.timestampMillis(), pastSnapshotTimeMil)) {
            return Stream.empty();
        }
        return StreamSupport.stream(icebergTable.snapshots().spliterator(), false).filter(s -> pastSnapshotTimeMil == null || s.timestampMillis() > pastSnapshotTimeMil).filter(s -> s.timestampMillis() <= currentSnapshot.timestampMillis()).filter(s -> !s.operation().equals("replace"));
    }
}

