/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction.evaluator.amoro;

import java.util.Objects;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableFormat;
import org.apache.iceberg.mr.hive.compaction.evaluator.amoro.TableIdentifier;

public class ServerTableIdentifier {
    private Long id;
    private String catalog;
    private String database;
    private String tableName;
    private TableFormat format;

    private ServerTableIdentifier() {
    }

    private ServerTableIdentifier(TableIdentifier tableIdentifier, TableFormat format) {
        this.catalog = tableIdentifier.getCatalog();
        this.database = tableIdentifier.getDatabase();
        this.tableName = tableIdentifier.getTableName();
        this.format = format;
    }

    private ServerTableIdentifier(String catalog, String database, String tableName, TableFormat format) {
        this.catalog = catalog;
        this.database = database;
        this.tableName = tableName;
        this.format = format;
    }

    private ServerTableIdentifier(Long id, String catalog, String database, String tableName, TableFormat format) {
        this.id = id;
        this.catalog = catalog;
        this.database = database;
        this.tableName = tableName;
        this.format = format;
    }

    public Long getId() {
        return this.id;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableFormat getFormat() {
        return this.format;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFormat(TableFormat format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerTableIdentifier that = (ServerTableIdentifier)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.database, that.database) && Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.catalog, this.database, this.tableName);
    }

    public String toString() {
        return String.format("%s.%s.%s(tableId=%d)", this.catalog, this.database, this.tableName, this.id);
    }

    public static ServerTableIdentifier of(TableIdentifier tableIdentifier, TableFormat format) {
        return new ServerTableIdentifier(tableIdentifier, format);
    }

    public static ServerTableIdentifier of(String catalog, String database, String tableName, TableFormat format) {
        return new ServerTableIdentifier(catalog, database, tableName, format);
    }

    public static ServerTableIdentifier of(Long id, String catalog, String database, String tableName, TableFormat format) {
        return new ServerTableIdentifier(id, catalog, database, tableName, format);
    }

    public TableIdentifier getIdentifier() {
        return new TableIdentifier(this.catalog, this.database, this.tableName);
    }
}

