/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.mr.hive.vector.HiveRow;

public class HiveBatchContext {
    private final VectorizedRowBatch batch;
    private final VectorizedRowBatchCtx vrbCtx;
    private final long fileRowOffset;

    public HiveBatchContext(VectorizedRowBatch batch, VectorizedRowBatchCtx vrbCtx, long fileRowOffset) {
        this.batch = batch;
        this.vrbCtx = vrbCtx;
        this.fileRowOffset = fileRowOffset;
    }

    public VectorizedRowBatch getBatch() {
        return this.batch;
    }

    public CloseableIterator<HiveRow> rowIterator() throws IOException {
        return new RowIterator();
    }

    class RowIterator
    implements CloseableIterator<HiveRow> {
        private final VectorExtractRow vectorExtractRow;
        private final int originalSize;
        private final int[] originalIndices;
        private int currentPosition = 0;

        RowIterator() throws IOException {
            try {
                this.vectorExtractRow = new VectorExtractRow();
                this.vectorExtractRow.init(HiveBatchContext.this.vrbCtx.getRowColumnTypeInfos());
                this.originalSize = HiveBatchContext.this.batch.size;
                this.originalIndices = HiveBatchContext.this.batch.isSelectedInUse() ? Arrays.copyOf(HiveBatchContext.this.batch.selected, HiveBatchContext.this.batch.size) : IntStream.range(0, HiveBatchContext.this.batch.size).toArray();
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition < this.originalSize;
        }

        @Override
        public HiveRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int logicalPosition = this.currentPosition++;
            final int physicalPosition = this.originalIndices[logicalPosition];
            HiveRow row = new HiveRow(){

                @Override
                public Object get(int rowIndex) {
                    if (rowIndex == MetadataColumns.ROW_POSITION.fieldId()) {
                        if (HiveBatchContext.this.fileRowOffset == Long.MIN_VALUE) {
                            throw new UnsupportedOperationException("Can't provide row position for batch.");
                        }
                        return HiveBatchContext.this.fileRowOffset + (long)physicalPosition;
                    }
                    return ((Function)RowIterator.this.vectorExtractRow.accessor(HiveBatchContext.this.batch).apply(physicalPosition)).apply(rowIndex);
                }

                @Override
                public int physicalBatchIndex() {
                    return physicalPosition;
                }
            };
            return row;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

