/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.VertexLocationHint;

@InterfaceAudience.Public
public class DataSourceDescriptor {
    private final InputDescriptor inputDescriptor;
    private final InputInitializerDescriptor initializerDescriptor;
    private final Credentials credentials;
    private final int numShards;
    private final VertexLocationHint locationHint;
    private final Map<String, LocalResource> additionalLocalFiles;
    private final Collection<URI> urisForCredentials = Sets.newHashSet();

    private DataSourceDescriptor(InputDescriptor inputDescriptor, @Nullable InputInitializerDescriptor initializerDescriptor, @Nullable Credentials credentials) {
        this(inputDescriptor, initializerDescriptor, -1, credentials, null, null);
    }

    private DataSourceDescriptor(InputDescriptor inputDescriptor, @Nullable InputInitializerDescriptor initializerDescriptor, int numShards, @Nullable Credentials credentials, @Nullable VertexLocationHint locationHint, @Nullable Map<String, LocalResource> additionalLocalFiles) {
        this.inputDescriptor = inputDescriptor;
        this.initializerDescriptor = initializerDescriptor;
        this.numShards = numShards;
        this.credentials = credentials;
        this.locationHint = locationHint;
        this.additionalLocalFiles = additionalLocalFiles;
    }

    public static DataSourceDescriptor create(InputDescriptor inputDescriptor, @Nullable InputInitializerDescriptor initializerDescriptor, @Nullable Credentials credentials) {
        return new DataSourceDescriptor(inputDescriptor, initializerDescriptor, credentials);
    }

    public static DataSourceDescriptor create(InputDescriptor inputDescriptor, @Nullable InputInitializerDescriptor initializerDescriptor, int numShards, @Nullable Credentials credentials, @Nullable VertexLocationHint locationHint, @Nullable Map<String, LocalResource> additionalLocalFiles) {
        return new DataSourceDescriptor(inputDescriptor, initializerDescriptor, numShards, credentials, locationHint, additionalLocalFiles);
    }

    public InputDescriptor getInputDescriptor() {
        return this.inputDescriptor;
    }

    @Nullable
    public InputInitializerDescriptor getInputInitializerDescriptor() {
        return this.initializerDescriptor;
    }

    public synchronized DataSourceDescriptor addURIsForCredentials(Collection<URI> uris) {
        Objects.requireNonNull(uris, "URIs cannot be null");
        this.urisForCredentials.addAll(uris);
        return this;
    }

    public Collection<URI> getURIsForCredentials() {
        return Collections.unmodifiableCollection(this.urisForCredentials);
    }

    @InterfaceAudience.Private
    public int getNumberOfShards() {
        return this.numShards;
    }

    @InterfaceAudience.Private
    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    @InterfaceAudience.Private
    @Nullable
    public VertexLocationHint getLocationHint() {
        return this.locationHint;
    }

    @InterfaceAudience.Private
    @Nullable
    public Map<String, LocalResource> getAdditionalLocalFiles() {
        return this.additionalLocalFiles;
    }
}

