/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.encoded;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.ConsumerFeedback;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.SchemaAwareCacheKey;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.llap.counters.QueryFragmentCounters;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.hive.llap.io.decode.GenericColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcEncodedDataConsumer;
import org.apache.hadoop.hive.llap.io.encoded.LineRrOffsetReader;
import org.apache.hadoop.hive.llap.io.encoded.PassThruOffsetReader;
import org.apache.hadoop.hive.llap.io.encoded.TezCounterSource;
import org.apache.hadoop.hive.llap.io.encoded.VectorDeserializeOrcWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.orc.encoded.StoppableAllocator;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.FixedSizedObjectPool;
import org.apache.hive.common.util.Ref;
import org.apache.orc.CompressionKind;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.SchemaEvolution;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.writer.StreamOptions;
import org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.counters.TezCounters;

public class SerDeEncodedDataReader
extends CallableWithNdc<Void>
implements ConsumerFeedback<Reader.OrcEncodedColumnBatch>,
TezCounterSource {
    public static final FixedSizedObjectPool<EncodedColumnBatch.ColumnStreamData> CSD_POOL = new FixedSizedObjectPool(8192, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

        public EncodedColumnBatch.ColumnStreamData create() {
            return new EncodedColumnBatch.ColumnStreamData();
        }

        public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
            t.reset();
        }
    });
    public static final FixedSizedObjectPool<Reader.OrcEncodedColumnBatch> ECB_POOL = new FixedSizedObjectPool(1024, (Pool.PoolObjectHelper)new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

        public Reader.OrcEncodedColumnBatch create() {
            return new Reader.OrcEncodedColumnBatch();
        }

        public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
            t.reset();
        }
    });
    private static final DataCache.DiskRangeListFactory CC_FACTORY = new DataCache.DiskRangeListFactory(){

        public DiskRangeList createCacheChunk(MemoryBuffer buffer, long offset, long end) {
            return new CacheChunk(buffer, offset, end);
        }
    };
    private final SerDeLowLevelCacheImpl cache;
    private final BufferUsageManager bufferManager;
    private final Allocator.BufferObjectFactory bufferFactory;
    private final Configuration daemonConf;
    private final FileSplit split;
    private List<Integer> columnIds;
    private final OrcEncodedDataConsumer consumer;
    private final QueryFragmentCounters counters;
    private final UserGroupInformation ugi;
    private final Map<Path, PartitionDesc> parts;
    private final Object fileKey;
    private final CacheTag cacheTag;
    private final FileSystem fs;
    private AtomicBoolean isStopped = new AtomicBoolean(false);
    private final Deserializer sourceSerDe;
    private final InputFormat<?, ?> sourceInputFormat;
    private final Reporter reporter;
    private final JobConf jobConf;
    private final TypeDescription schema;
    private final int allocSize;
    private final int targetSliceRowCount;
    private final boolean isLrrEnabled;
    private final boolean useObjectPools;
    private final boolean[] writerIncludes;
    private FileReaderYieldReturn currentFileRead = null;
    private final boolean isReadCacheOnly;
    private final ExecutorService encodeExecutor;
    private SerDeLowLevelCacheImpl.FileData cachedData;
    private List<VectorDeserializeOrcWriter> asyncWriters = new ArrayList<VectorDeserializeOrcWriter>();
    private static final NoopMemoryManager MEMORY_MANAGER = new NoopMemoryManager();

    public SerDeEncodedDataReader(SerDeLowLevelCacheImpl cache, BufferUsageManager bufferManager, Configuration daemonConf, FileSplit split, List<Integer> columnIds, OrcEncodedDataConsumer consumer, JobConf jobConf, Reporter reporter, InputFormat<?, ?> sourceInputFormat, Deserializer sourceSerDe, QueryFragmentCounters counters, TypeDescription schema, Map<Path, PartitionDesc> parts, ExecutorService encodeExecutor) throws IOException {
        assert (cache != null);
        this.cache = cache;
        this.bufferManager = bufferManager;
        this.bufferFactory = new Allocator.BufferObjectFactory(this){

            public MemoryBuffer create() {
                return new SerDeLowLevelCacheImpl.LlapSerDeDataBuffer();
            }
        };
        this.parts = parts;
        this.daemonConf = new Configuration(daemonConf);
        this.daemonConf.setDouble(OrcConf.DICTIONARY_KEY_SIZE_THRESHOLD.name(), 0.0);
        this.split = split;
        this.columnIds = columnIds;
        this.allocSize = SerDeEncodedDataReader.determineAllocSize(bufferManager, daemonConf);
        boolean isInTest = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST);
        JobConf sliceConf = isInTest ? jobConf : daemonConf;
        this.targetSliceRowCount = HiveConf.getIntVar((Configuration)sliceConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_SLICE_ROW_COUNT);
        this.isLrrEnabled = HiveConf.getBoolVar((Configuration)sliceConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_SLICE_LRR);
        this.useObjectPools = HiveConf.getBoolVar((Configuration)sliceConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_SHARE_OBJECT_POOLS);
        if (this.columnIds != null) {
            Collections.sort(this.columnIds);
        }
        this.consumer = consumer;
        this.counters = counters;
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fs = split.getPath().getFileSystem((Configuration)jobConf);
        PartitionDesc partitionDesc = LlapHiveUtils.partitionDescForPath((Path)split.getPath(), parts);
        this.fileKey = SerDeEncodedDataReader.determineCacheKey(this.fs, split, partitionDesc, daemonConf);
        this.cacheTag = HiveConf.getBoolVar((Configuration)daemonConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE) ? LlapHiveUtils.getDbAndTableNameForMetrics((Path)split.getPath(), (boolean)true, (PartitionDesc)partitionDesc) : null;
        this.sourceInputFormat = sourceInputFormat;
        this.sourceSerDe = sourceSerDe;
        this.reporter = reporter;
        this.jobConf = jobConf;
        boolean useDecimal64ColumnVectors = HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZED_INPUT_FORMAT_SUPPORTS_ENABLED).equalsIgnoreCase("decimal_64");
        consumer.setUseDecimal64ColumnVectors(useDecimal64ColumnVectors);
        this.schema = schema;
        this.writerIncludes = OrcInputFormat.genIncludedColumns((TypeDescription)schema, columnIds);
        SchemaEvolution evolution = new SchemaEvolution(schema, null, new Reader.Options((Configuration)jobConf).include(this.writerIncludes));
        consumer.setSchemaEvolution(evolution);
        this.isReadCacheOnly = HiveConf.getBoolVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_CACHE_ONLY);
        this.encodeExecutor = encodeExecutor;
    }

    private static int determineAllocSize(BufferUsageManager bufferManager, Configuration conf) {
        int maxAllocSize;
        long allocSize = HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENCODE_ALLOC_SIZE);
        if (allocSize > (long)(maxAllocSize = bufferManager.getAllocator().getMaxAllocation())) {
            LlapIoImpl.LOG.error("Encode allocation size " + allocSize + " is being capped to the maximum allocation size " + bufferManager.getAllocator().getMaxAllocation());
            allocSize = maxAllocSize;
        }
        return (int)allocSize;
    }

    @Override
    public void stop() {
        LlapIoImpl.LOG.debug("Encoded reader is being stopped");
        this.isStopped.set(true);
    }

    @Override
    public void pause() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unpause() {
        throw new UnsupportedOperationException();
    }

    protected Void callInternal() throws IOException, InterruptedException {
        return (Void)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                return SerDeEncodedDataReader.this.performDataRead();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void performDataRead() throws IOException, InterruptedException {
        long startTime;
        boolean isOk;
        block16: {
            Iterator<SerDeLowLevelCacheImpl.StripeData> iterator;
            Boolean isFromCache;
            block15: {
                block13: {
                    isOk = false;
                    startTime = this.counters.startTimeCounter();
                    LlapIoImpl.LOG.info("Processing data for {}", (Object)this.split.getPath());
                    if (!this.processStop()) break block13;
                    this.recordReaderTime(startTime);
                    Void void_ = null;
                    this.cleanup(!isOk);
                    return void_;
                }
                isFromCache = null;
                try {
                    isFromCache = this.readFileWithCache(startTime);
                }
                finally {
                    if (this.cachedData != null && this.cachedData.getData() != null) {
                        for (SerDeLowLevelCacheImpl.StripeData sd : this.cachedData.getData()) {
                            this.unlockAllBuffers(sd);
                        }
                        this.cachedData = null;
                    }
                }
                if (isFromCache != null) break block15;
                iterator = null;
                this.cleanup(!isOk);
                return iterator;
            }
            if (isFromCache.booleanValue() || this.processOneFileSplit(this.split, startTime, (Ref<Integer>)Ref.from((Object)0), null)) break block16;
            iterator = null;
            this.cleanup(!isOk);
            return iterator;
        }
        try {
            try {
                this.recordReaderTime(startTime);
                if (LlapIoImpl.LOG.isTraceEnabled()) {
                    LlapIoImpl.LOG.trace("done processing {}", (Object)this.split);
                }
            }
            catch (Throwable e) {
                LlapIoImpl.LOG.error("Exception while processing", e);
                this.consumer.setError(e);
                throw e;
            }
            this.consumer.setDone();
            isOk = true;
            Void void_ = null;
            this.cleanup(!isOk);
            return void_;
        }
        catch (Throwable throwable) {
            this.cleanup(!isOk);
            throw throwable;
        }
    }

    private void unlockAllBuffers(SerDeLowLevelCacheImpl.StripeData si) {
        for (int i = 0; i < si.getData().length; ++i) {
            SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] colData = si.getData()[i];
            if (colData == null) continue;
            for (int j = 0; j < colData.length; ++j) {
                SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[] streamData = colData[j];
                if (streamData == null) continue;
                for (int k = 0; k < streamData.length; ++k) {
                    this.bufferManager.decRefBuffer(streamData[k]);
                }
            }
        }
    }

    public void cacheFileData(SerDeLowLevelCacheImpl.StripeData sd) {
        if (sd == null || sd.getEncodings() == null) {
            return;
        }
        if (this.fileKey != null) {
            OrcProto.ColumnEncoding[] encodings = sd.getEncodings();
            if (encodings[0] != null && sd.getData()[0] == null) {
                SerDeEncodedDataReader.createArrayToCache(sd, 0, null);
            }
            for (int i = 0; i < encodings.length; ++i) {
                if (sd.getData()[i] == null) {
                    encodings[i] = null;
                    continue;
                }
                if (encodings[i] == null) {
                    throw new AssertionError((Object)("Caching data without an encoding at " + i + ": " + String.valueOf(sd)));
                }
            }
            SerDeLowLevelCacheImpl.FileData fd = new SerDeLowLevelCacheImpl.FileData(this.daemonConf, this.fileKey, encodings.length);
            fd.addStripe(sd);
            this.cache.putFileData(fd, LowLevelCache.Priority.NORMAL, this.counters, this.cacheTag);
        } else {
            this.lockAllBuffers(sd);
        }
    }

    private void lockAllBuffers(SerDeLowLevelCacheImpl.StripeData sd) {
        for (int i = 0; i < sd.getData().length; ++i) {
            SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] colData = sd.getData()[i];
            if (colData == null) continue;
            for (int j = 0; j < colData.length; ++j) {
                SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[] streamData = colData[j];
                if (streamData == null) continue;
                for (int k = 0; k < streamData.length; ++k) {
                    boolean canLock = this.bufferManager.incRefBuffer(streamData[k]);
                    assert (canLock);
                }
            }
        }
    }

    public Boolean readFileWithCache(long startTime) throws IOException, InterruptedException {
        FileSplit splitPart;
        FileSplit sliceSplit;
        if (this.fileKey == null) {
            return false;
        }
        DataCache.BooleanRef gotAllData = new DataCache.BooleanRef();
        long endOfSplit = this.split.getStart() + this.split.getLength();
        this.cachedData = this.cache.getFileData(this.fileKey, this.split.getStart(), endOfSplit, this.writerIncludes, CC_FACTORY, this.counters, gotAllData);
        if (!gotAllData.value) {
            LlapHiveUtils.throwIfCacheOnlyRead((boolean)this.isReadCacheOnly);
        }
        if (this.cachedData == null) {
            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                LlapIoImpl.CACHE_LOGGER.trace("No data for the split found in cache");
            }
            return false;
        }
        String[] hosts = SerDeEncodedDataReader.extractHosts(this.split, false);
        String[] inMemoryHosts = SerDeEncodedDataReader.extractHosts(this.split, true);
        ArrayList<SerDeLowLevelCacheImpl.StripeData> slices = this.cachedData.getData();
        if (slices.isEmpty()) {
            return false;
        }
        long uncachedPrefixEnd = ((SerDeLowLevelCacheImpl.StripeData)slices.get(0)).getKnownTornStart();
        long uncachedSuffixStart = ((SerDeLowLevelCacheImpl.StripeData)slices.get(slices.size() - 1)).getLastEnd();
        long lastStripeLastStart = ((SerDeLowLevelCacheImpl.StripeData)slices.get(slices.size() - 1)).getLastStart();
        Ref stripeIx = Ref.from((Object)0);
        if (uncachedPrefixEnd > this.split.getStart() && !this.processOneFileSplit(sliceSplit = new FileSplit(this.split.getPath(), this.split.getStart(), uncachedPrefixEnd - this.split.getStart(), hosts, inMemoryHosts), startTime, (Ref<Integer>)stripeIx, null)) {
            return null;
        }
        while (!slices.isEmpty()) {
            SerDeLowLevelCacheImpl.StripeData slice = (SerDeLowLevelCacheImpl.StripeData)slices.get(0);
            long start = slice.getKnownTornStart();
            long len = slice.getLastStart() - start;
            FileSplit sliceSplit2 = new FileSplit(this.split.getPath(), start, len, hosts, inMemoryHosts);
            if (this.processOneFileSplit(sliceSplit2, startTime, (Ref<Integer>)stripeIx, slice)) continue;
            return null;
        }
        boolean isUnfortunate = false;
        if (uncachedSuffixStart == endOfSplit) {
            long size = this.split.getPath().getFileSystem(this.daemonConf).getFileStatus(this.split.getPath()).getLen();
            boolean bl = isUnfortunate = size > endOfSplit;
            if (isUnfortunate) {
                LlapIoImpl.LOG.warn("One-row mismatch at the end of split " + String.valueOf(this.split.getPath()) + " at " + endOfSplit + "; file size is " + size);
            }
        }
        if ((uncachedSuffixStart < endOfSplit || isUnfortunate) && !this.processOneFileSplit(splitPart = new FileSplit(this.split.getPath(), lastStripeLastStart, endOfSplit - lastStripeLastStart, hosts, inMemoryHosts), startTime, (Ref<Integer>)stripeIx, null)) {
            return null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processOneFileSplit(FileSplit split, long startTime, Ref<Integer> stripeIxRef, SerDeLowLevelCacheImpl.StripeData slice) throws IOException, InterruptedException {
        boolean result;
        block20: {
            boolean hasAllData;
            LlapIoImpl.LOG.info("Processing one split {" + String.valueOf(split.getPath()) + ", " + split.getStart() + ", " + split.getLength() + "}");
            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                LlapIoImpl.CACHE_LOGGER.trace("Cache data for the split is " + String.valueOf(slice));
            }
            boolean[] splitIncludes = Arrays.copyOf(this.writerIncludes, this.writerIncludes.length);
            boolean bl = hasAllData = slice != null && SerDeEncodedDataReader.determineSplitIncludes(slice, splitIncludes, this.writerIncludes);
            if (hasAllData) {
                CacheWriter.CacheStripeData csd = null;
                boolean result2 = this.processOneSlice(csd, splitIncludes, (int)((Integer)stripeIxRef.value), slice, startTime);
                Ref<Integer> ref = stripeIxRef;
                ref.value = (Integer)ref.value + 1;
                return result2;
            }
            result = false;
            this.startReadSplitFromFile(split, splitIncludes, slice);
            try {
                if (slice != null) {
                    Ref<Integer> cacheWriter;
                    Vectors vectors = this.currentFileRead.readNextSlice();
                    assert (vectors != null);
                    if (!vectors.isSupported()) {
                        cacheWriter = this.currentFileRead.getCacheWriter();
                        assert (cacheWriter.stripes.size() == 1);
                        result = this.processOneSlice(cacheWriter.stripes.get(0), splitIncludes, (int)((Integer)stripeIxRef.value), slice, startTime);
                    } else {
                        result = this.processOneSlice(vectors, splitIncludes, (int)((Integer)stripeIxRef.value), slice, startTime);
                    }
                    assert (null == this.currentFileRead.readNextSlice());
                    cacheWriter = stripeIxRef;
                    cacheWriter.value = (Integer)cacheWriter.value + 1;
                    break block20;
                }
                Vectors vectors = this.currentFileRead.readNextSlice();
                if (vectors == null) {
                    boolean cacheWriter = true;
                    return cacheWriter;
                }
                result = true;
                if (!vectors.isSupported()) {
                    while (this.currentFileRead.readNextSlice() != null) {
                    }
                    CacheWriter cacheWriter = this.currentFileRead.getCacheWriter();
                    for (CacheWriter.CacheStripeData csd : cacheWriter.stripes) {
                        if (!this.processOneSlice(csd, splitIncludes, (int)((Integer)stripeIxRef.value), null, startTime)) {
                            result = false;
                            break block20;
                        }
                        Ref<Integer> ref = stripeIxRef;
                        Integer.valueOf((Integer)ref.value + 1);
                        ref.value = ref.value;
                    }
                    break block20;
                }
                do {
                    assert (vectors.isSupported());
                    if (!this.processOneSlice(vectors, splitIncludes, (int)((Integer)stripeIxRef.value), null, startTime)) {
                        result = false;
                        break;
                    }
                    Ref<Integer> ref = stripeIxRef;
                    Integer.valueOf((Integer)ref.value + 1);
                    ref.value = ref.value;
                } while ((vectors = this.currentFileRead.readNextSlice()) != null);
            }
            finally {
                this.cleanUpCurrentRead();
            }
        }
        return result;
    }

    private static boolean determineSplitIncludes(SerDeLowLevelCacheImpl.StripeData slice, boolean[] splitIncludes, boolean[] writerIncludes) {
        OrcProto.ColumnEncoding[] cacheEncodings = slice.getEncodings();
        assert (cacheEncodings != null);
        boolean hasAllData = true;
        for (int colIx = 0; colIx < cacheEncodings.length; ++colIx) {
            if (!splitIncludes[colIx]) continue;
            if (cacheEncodings[colIx] != null != (slice.getData()[colIx] != null)) {
                throw new AssertionError((Object)("Inconsistent cache slice " + String.valueOf(slice)));
            }
            if (cacheEncodings[colIx] != null) {
                splitIncludes[colIx] = false;
                continue;
            }
            hasAllData = false;
        }
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("Includes accounting for cached data: before " + DebugUtils.toString((boolean[])writerIncludes) + ", after " + DebugUtils.toString((boolean[])splitIncludes));
        }
        return hasAllData;
    }

    private boolean processOneSlice(CacheWriter.CacheStripeData diskData, boolean[] splitIncludes, int stripeIx, SerDeLowLevelCacheImpl.StripeData cacheData, long startTime) throws IOException, InterruptedException {
        boolean hasAllData;
        this.logProcessOneSlice(stripeIx, diskData, cacheData);
        Object[] cacheEncodings = cacheData == null ? null : cacheData.getEncodings();
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][][] cacheBuffers = cacheData == null ? null : cacheData.getData();
        long cacheRowCount = cacheData == null ? -1L : cacheData.getRowCount();
        GenericColumnVectorProducer.SerDeStripeMetadata metadata = new GenericColumnVectorProducer.SerDeStripeMetadata(stripeIx);
        SerDeLowLevelCacheImpl.StripeData sliceToCache = null;
        boolean bl = hasAllData = diskData == null;
        if (!hasAllData) {
            sliceToCache = this.createSliceToCache(diskData, cacheData);
            metadata.setEncodings(SerDeEncodedDataReader.combineCacheAndWriterEncodings((OrcProto.ColumnEncoding[])cacheEncodings, diskData.encodings));
            metadata.setRowCount(diskData.rowCount);
        } else {
            metadata.setEncodings(Lists.newArrayList((Object[])cacheEncodings));
            metadata.setRowCount(cacheRowCount);
        }
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("Derived stripe metadata for this split is " + String.valueOf(metadata));
        }
        this.consumer.setStripeMetadata(metadata);
        Reader.OrcEncodedColumnBatch ecb = this.useObjectPools ? (Reader.OrcEncodedColumnBatch)ECB_POOL.take() : new Reader.OrcEncodedColumnBatch();
        ecb.init(this.fileKey, metadata.getStripeIx(), -1, this.writerIncludes.length);
        for (int colIx = 1; colIx < this.writerIncludes.length; ++colIx) {
            if (!this.writerIncludes[colIx]) continue;
            ecb.initColumn(colIx, Reader.OrcEncodedColumnBatch.MAX_DATA_STREAMS);
            if (!hasAllData && splitIncludes[colIx]) {
                List<CacheWriter.CacheStreamData> streams = diskData.colStreams.get(colIx);
                SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] newCacheDataForCol = SerDeEncodedDataReader.createArrayToCache(sliceToCache, colIx, streams);
                if (streams == null) continue;
                Iterator<CacheWriter.CacheStreamData> iter = streams.iterator();
                while (iter.hasNext()) {
                    CacheWriter.CacheStreamData stream = iter.next();
                    if (stream.isSuppressed) {
                        if (LlapIoImpl.LOG.isTraceEnabled()) {
                            LlapIoImpl.LOG.trace("Removing a suppressed stream " + String.valueOf(stream.name));
                        }
                        iter.remove();
                        this.discardUncachedBuffers(stream.data);
                        continue;
                    }
                    int streamIx = SerDeEncodedDataReader.setStreamDataToCache(newCacheDataForCol, stream);
                    EncodedColumnBatch.ColumnStreamData cb = this.useObjectPools ? (EncodedColumnBatch.ColumnStreamData)CSD_POOL.take() : new EncodedColumnBatch.ColumnStreamData();
                    cb.incRef();
                    cb.setCacheBuffers(stream.data);
                    ecb.setStreamData(colIx, streamIx, cb);
                }
                continue;
            }
            this.processColumnCacheData(cacheBuffers, ecb, colIx);
        }
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return false;
        }
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Data to cache from the read " + String.valueOf(sliceToCache));
        }
        this.cacheFileData(sliceToCache);
        return this.sendEcbToConsumer(ecb, cacheData != null, diskData);
    }

    private void validateCacheAndDisk(SerDeLowLevelCacheImpl.StripeData cacheData, long rowCount, long encodingCount, Object diskDataLog) throws IOException {
        if (rowCount != cacheData.getRowCount()) {
            throw new IOException("Row count mismatch; disk " + rowCount + ", cache " + cacheData.getRowCount() + " from " + String.valueOf(diskDataLog) + " and " + String.valueOf(cacheData));
        }
        if (encodingCount > 0L && encodingCount != (long)cacheData.getEncodings().length) {
            throw new IOException("Column count mismatch; disk " + encodingCount + ", cache " + cacheData.getEncodings().length + " from " + String.valueOf(diskDataLog) + " and " + String.valueOf(cacheData));
        }
    }

    private boolean processOneSlice(Vectors diskData, boolean[] splitIncludes, int stripeIx, SerDeLowLevelCacheImpl.StripeData cacheData, long startTime) throws IOException, InterruptedException {
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][][] cacheBuffers;
        if (diskData == null) {
            throw new AssertionError();
        }
        this.logProcessOneSlice(stripeIx, diskData, cacheData);
        if (cacheData == null && diskData.getRowCount() == 0L) {
            return true;
        }
        OrcProto.ColumnEncoding[] cacheEncodings = cacheData == null ? null : cacheData.getEncodings();
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][][] llapSerDeDataBufferArray = cacheBuffers = cacheData == null ? null : cacheData.getData();
        if (cacheData != null) {
            this.validateCacheAndDisk(cacheData, diskData.getRowCount(), -1L, diskData);
        }
        GenericColumnVectorProducer.SerDeStripeMetadata metadata = new GenericColumnVectorProducer.SerDeStripeMetadata(stripeIx);
        metadata.setEncodings(Arrays.asList(cacheEncodings == null ? new OrcProto.ColumnEncoding[splitIncludes.length] : cacheEncodings));
        metadata.setRowCount(diskData.getRowCount());
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("Derived stripe metadata for this split is " + String.valueOf(metadata));
        }
        this.consumer.setStripeMetadata(metadata);
        Reader.OrcEncodedColumnBatch ecb = this.useObjectPools ? (Reader.OrcEncodedColumnBatch)ECB_POOL.take() : new Reader.OrcEncodedColumnBatch();
        ecb.init(this.fileKey, metadata.getStripeIx(), -1, this.writerIncludes.length);
        int vectorsIx = 0;
        for (int colIx = 0; colIx < this.writerIncludes.length; ++colIx) {
            if (colIx == 0 || !this.writerIncludes[colIx]) continue;
            if (splitIncludes[colIx]) {
                List<ColumnVector> vectors = diskData.getVectors(vectorsIx++);
                if (LlapIoImpl.LOG.isTraceEnabled()) {
                    LlapIoImpl.LOG.trace("Processing vectors for column " + colIx + ": " + String.valueOf(vectors));
                }
                ecb.initColumnWithVectors(colIx, vectors);
                continue;
            }
            ecb.initColumn(colIx, Reader.OrcEncodedColumnBatch.MAX_DATA_STREAMS);
            this.processColumnCacheData(cacheBuffers, ecb, colIx);
        }
        if (this.processStop()) {
            this.recordReaderTime(startTime);
            return false;
        }
        return this.sendEcbToConsumer(ecb, cacheData != null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsyncCacheData(CacheWriter.CacheStripeData diskData, boolean[] splitIncludes) throws IOException {
        SerDeLowLevelCacheImpl.StripeData sliceToCache = new SerDeLowLevelCacheImpl.StripeData(diskData.knownTornStart, diskData.firstRowStart, diskData.lastRowStart, diskData.lastRowEnd, diskData.rowCount, diskData.encodings.toArray(new OrcProto.ColumnEncoding[diskData.encodings.size()]));
        for (int colIx = 0; colIx < splitIncludes.length; ++colIx) {
            if (!splitIncludes[colIx]) continue;
            List<CacheWriter.CacheStreamData> streams = diskData.colStreams.get(colIx);
            SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] newCacheDataForCol = SerDeEncodedDataReader.createArrayToCache(sliceToCache, colIx, streams);
            if (streams == null) continue;
            Iterator<CacheWriter.CacheStreamData> iter = streams.iterator();
            while (iter.hasNext()) {
                CacheWriter.CacheStreamData stream = iter.next();
                if (stream.isSuppressed) {
                    if (LlapIoImpl.LOG.isTraceEnabled()) {
                        LlapIoImpl.LOG.trace("Removing a suppressed stream " + String.valueOf(stream.name));
                    }
                    iter.remove();
                    this.discardUncachedBuffers(stream.data);
                    continue;
                }
                SerDeEncodedDataReader.setStreamDataToCache(newCacheDataForCol, stream);
            }
        }
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Data to cache from async read " + String.valueOf(sliceToCache));
        }
        try {
            this.cacheFileData(sliceToCache);
        }
        finally {
            this.unlockAllBuffers(sliceToCache);
        }
    }

    private SerDeLowLevelCacheImpl.StripeData createSliceToCache(CacheWriter.CacheStripeData diskData, SerDeLowLevelCacheImpl.StripeData cacheData) throws IOException {
        assert (diskData != null);
        if (cacheData == null) {
            return new SerDeLowLevelCacheImpl.StripeData(diskData.knownTornStart, diskData.firstRowStart, diskData.lastRowStart, diskData.lastRowEnd, diskData.rowCount, diskData.encodings.toArray(new OrcProto.ColumnEncoding[diskData.encodings.size()]));
        }
        long rowCount = diskData.rowCount;
        long encodingCount = diskData.encodings.size();
        this.validateCacheAndDisk(cacheData, rowCount, encodingCount, diskData);
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            LlapIoImpl.LOG.debug("Creating slice to cache in addition to an existing slice " + cacheData.toCoordinateString() + "; disk offsets were " + diskData.toCoordinateString());
        }
        SerDeLowLevelCacheImpl.StripeData sliceToCache = SerDeLowLevelCacheImpl.StripeData.duplicateStructure(cacheData);
        for (int i = 0; i < diskData.encodings.size(); ++i) {
            sliceToCache.getEncodings()[i] = diskData.encodings.get(i);
        }
        sliceToCache.setKnownTornStart(Math.min(diskData.knownTornStart, sliceToCache.getKnownTornStart()));
        return sliceToCache;
    }

    private static SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] createArrayToCache(SerDeLowLevelCacheImpl.StripeData sliceToCache, int colIx, List<CacheWriter.CacheStreamData> streams) {
        if (LlapIoImpl.LOG.isTraceEnabled()) {
            LlapIoImpl.LOG.trace("Processing streams for column " + colIx + ": " + String.valueOf(streams));
        }
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] llapSerDeDataBufferArray = new SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[Reader.OrcEncodedColumnBatch.MAX_DATA_STREAMS][];
        sliceToCache.getData()[colIx] = llapSerDeDataBufferArray;
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] newCacheDataForCol = llapSerDeDataBufferArray;
        return newCacheDataForCol;
    }

    private static int setStreamDataToCache(SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] newCacheDataForCol, CacheWriter.CacheStreamData stream) {
        int streamIx = stream.name.getKind().getNumber();
        newCacheDataForCol[streamIx] = stream.data.toArray(new SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[stream.data.size()]);
        return streamIx;
    }

    private void processColumnCacheData(SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][][] cacheBuffers, Reader.OrcEncodedColumnBatch ecb, int colIx) {
        SerDeLowLevelCacheImpl.LlapSerDeDataBuffer[][] colData = cacheBuffers[colIx];
        if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
            LlapIoImpl.CACHE_LOGGER.trace("Processing cache data for column " + colIx + ": " + SerDeLowLevelCacheImpl.toString(colData));
        }
        for (int streamIx = 0; streamIx < colData.length; ++streamIx) {
            if (colData[streamIx] == null) continue;
            EncodedColumnBatch.ColumnStreamData cb = this.useObjectPools ? (EncodedColumnBatch.ColumnStreamData)CSD_POOL.take() : new EncodedColumnBatch.ColumnStreamData();
            cb.incRef();
            cb.setCacheBuffers((List)Lists.newArrayList((Object[])colData[streamIx]));
            ecb.setStreamData(colIx, streamIx, cb);
        }
    }

    private void logProcessOneSlice(int stripeIx, Object diskData, SerDeLowLevelCacheImpl.StripeData cacheData) {
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            String sliceStr = cacheData == null ? "null" : cacheData.toCoordinateString();
            LlapIoImpl.LOG.debug("Processing slice #" + stripeIx + " " + sliceStr + "; has" + (cacheData == null ? " no" : "") + " cache data; has" + (diskData == null ? " no" : "") + " disk data");
        }
    }

    private void discardUncachedBuffers(List<MemoryBuffer> list) {
        for (MemoryBuffer buffer : list) {
            this.bufferManager.getAllocator().deallocate(buffer);
        }
    }

    private static List<OrcProto.ColumnEncoding> combineCacheAndWriterEncodings(OrcProto.ColumnEncoding[] cacheEncodings, List<OrcProto.ColumnEncoding> writerEncodings) throws IOException {
        if (cacheEncodings == null) {
            return new ArrayList<OrcProto.ColumnEncoding>(writerEncodings);
        }
        if (cacheEncodings.length != writerEncodings.size()) {
            throw new IOException("Incompatible encoding lengths: " + Arrays.toString(cacheEncodings) + " vs " + String.valueOf(writerEncodings));
        }
        Object[] combinedEncodings = Arrays.copyOf(cacheEncodings, cacheEncodings.length);
        for (int colIx = 0; colIx < cacheEncodings.length; ++colIx) {
            OrcProto.ColumnEncoding newEncoding = writerEncodings.get(colIx);
            if (newEncoding == null) continue;
            if (combinedEncodings[colIx] != null && !newEncoding.equals(combinedEncodings[colIx])) {
                throw new IOException("Incompatible encodings at " + colIx + ": " + Arrays.toString(cacheEncodings) + " vs " + String.valueOf(writerEncodings));
            }
            combinedEncodings[colIx] = newEncoding;
        }
        return Lists.newArrayList((Object[])combinedEncodings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReadSplitFromFile(FileSplit split, boolean[] splitIncludes, SerDeLowLevelCacheImpl.StripeData slice) throws IOException {
        boolean maySplitTheSplit = slice == null;
        ReaderWithOffsets offsetReader = null;
        RecordReader sourceReader = this.sourceInputFormat.getRecordReader((InputSplit)split, this.jobConf, this.reporter);
        Path path = split.getPath().getFileSystem(this.daemonConf).makeQualified(split.getPath());
        PartitionDesc partDesc = (PartitionDesc)HiveFileFormatUtils.getFromPathRecursively(this.parts, (Path)path, null);
        try {
            offsetReader = this.createOffsetReader(sourceReader, partDesc.getTableDesc(), split);
            sourceReader = null;
        }
        finally {
            if (sourceReader != null) {
                try {
                    sourceReader.close();
                }
                catch (Exception ex) {
                    LlapIoImpl.LOG.error("Failed to close source reader", (Throwable)ex);
                }
            }
        }
        maySplitTheSplit = maySplitTheSplit && offsetReader.hasOffsets();
        try {
            StructObjectInspector originalOi = (StructObjectInspector)this.getOiFromSerDe();
            List<Integer> splitColumnIds = OrcInputFormat.genIncludedColumnsReverse((TypeDescription)this.schema, (boolean[])splitIncludes, (boolean)false);
            EncodingWriter writer = VectorDeserializeOrcWriter.create(this.sourceInputFormat, this.sourceSerDe, this.parts, this.daemonConf, (Configuration)this.jobConf, split.getPath(), originalOi, splitColumnIds, splitIncludes, this.allocSize, this.encodeExecutor);
            List<Integer> cwColIds = writer.isOnlyWritingIncludedColumns() ? splitColumnIds : this.columnIds;
            writer.init(new CacheWriter(this.bufferManager, cwColIds, splitIncludes, writer.isOnlyWritingIncludedColumns(), this.bufferFactory, this.isStopped), this.daemonConf, split.getPath());
            if (writer instanceof VectorDeserializeOrcWriter) {
                VectorDeserializeOrcWriter asyncWriter = (VectorDeserializeOrcWriter)writer;
                asyncWriter.startAsync(new AsyncCacheDataCallback());
                this.asyncWriters.add(asyncWriter);
            }
            this.currentFileRead = new FileReaderYieldReturn(offsetReader, split, writer, maySplitTheSplit, this.targetSliceRowCount);
        }
        finally {
            if (this.currentFileRead != null) {
                return;
            }
            if (offsetReader == null) {
                return;
            }
            try {
                offsetReader.close();
            }
            catch (Exception ex) {
                LlapIoImpl.LOG.error("Failed to close source reader", (Throwable)ex);
            }
        }
    }

    static OrcFile.WriterOptions createOrcWriterOptions(ObjectInspector sourceOi, Configuration conf, CacheWriter cacheWriter, int allocSize) throws IOException {
        return OrcFile.writerOptions((Configuration)conf).stripeSize(Long.MAX_VALUE).blockSize(Long.MAX_VALUE).rowIndexStride(Integer.MAX_VALUE).blockPadding(false).compress(CompressionKind.NONE).version(OrcFile.Version.CURRENT).encodingStrategy(OrcFile.EncodingStrategy.SPEED).bloomFilterColumns(null).inspector(sourceOi).physicalWriter((PhysicalWriter)cacheWriter).memory((MemoryManager)MEMORY_MANAGER).bufferSize(allocSize);
    }

    private ObjectInspector getOiFromSerDe() throws IOException {
        try {
            return this.sourceSerDe.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    private ReaderWithOffsets createOffsetReader(RecordReader<?, ?> sourceReader, TableDesc tableDesc, FileSplit split) throws IOException {
        int headerCount = Utilities.getHeaderCount((TableDesc)tableDesc);
        int footerCount = Utilities.getFooterCount((TableDesc)tableDesc, (JobConf)this.jobConf);
        if (LlapIoImpl.LOG.isDebugEnabled()) {
            LlapIoImpl.LOG.debug("Using {} to read data with skip.header.line.count {} and skip.footer.line.count {}", new Object[]{sourceReader.getClass().getSimpleName(), headerCount, footerCount});
        }
        if (this.isLrrEnabled && sourceReader instanceof LineRecordReader) {
            return LineRrOffsetReader.create((LineRecordReader)sourceReader, this.jobConf, headerCount, footerCount, split);
        }
        return new PassThruOffsetReader(sourceReader, this.jobConf, headerCount, footerCount);
    }

    private static String[] extractHosts(FileSplit split, boolean isInMemory) throws IOException {
        SplitLocationInfo[] locInfo = split.getLocationInfo();
        if (locInfo == null) {
            return new String[0];
        }
        ArrayList<String> hosts = null;
        for (int i = 0; i < locInfo.length; ++i) {
            if (locInfo[i].isInMemory() != isInMemory) continue;
            if (hosts == null) {
                hosts = new ArrayList<String>();
            }
            hosts.add(locInfo[i].getLocation());
        }
        if (hosts == null) {
            return new String[0];
        }
        return hosts.toArray(new String[hosts.size()]);
    }

    private boolean sendEcbToConsumer(Reader.OrcEncodedColumnBatch ecb, boolean hasCachedSlice, CacheWriter.CacheStripeData diskData) throws InterruptedException {
        if (ecb == null) {
            this.cleanup(true);
            return false;
        }
        LlapIoImpl.LOG.trace("Sending a batch over to consumer");
        this.consumer.consumeData(ecb);
        if (hasCachedSlice) {
            this.cachedData.getData().remove(0);
        }
        if (diskData != null) {
            diskData.colStreams.clear();
        }
        return true;
    }

    private void cleanup(boolean isError) {
        this.cleanUpCurrentRead();
        if (!isError) {
            return;
        }
        for (VectorDeserializeOrcWriter asyncWriter : this.asyncWriters) {
            try {
                asyncWriter.interrupt();
            }
            catch (Exception ex) {
                LlapIoImpl.LOG.warn("Failed to interrupt an async writer", (Throwable)ex);
            }
        }
        this.asyncWriters.clear();
    }

    private void cleanUpCurrentRead() {
        if (this.currentFileRead == null) {
            return;
        }
        try {
            this.currentFileRead.closeOffsetReader();
            this.currentFileRead = null;
        }
        catch (Exception ex) {
            LlapIoImpl.LOG.error("Failed to close current file reader", (Throwable)ex);
        }
    }

    private void recordReaderTime(long startTime) {
        this.counters.incrWallClockCounter(LlapIOCounters.TOTAL_IO_TIME_NS, startTime);
    }

    private boolean processStop() {
        if (!this.isStopped.get()) {
            return false;
        }
        LlapIoImpl.LOG.info("SerDe-based data reader is stopping");
        this.cleanup(true);
        return true;
    }

    private static Object determineCacheKey(FileSystem fs, FileSplit split, PartitionDesc partitionDesc, Configuration daemonConf) throws IOException {
        LlapIoImpl.LOG.warn("Split for " + String.valueOf(split.getPath()) + " (" + String.valueOf(split.getClass()) + ") does not have file ID");
        Object fileId = LlapHiveUtils.createFileIdUsingFS((FileSystem)fs, (Path)split.getPath(), (Configuration)daemonConf);
        return SchemaAwareCacheKey.buildCacheKey((Object)fileId, (int)LlapHiveUtils.getSchemaHash((PartitionDesc)partitionDesc));
    }

    @Override
    public void returnData(Reader.OrcEncodedColumnBatch ecb) {
        for (int colIx = 0; colIx < ecb.getTotalColCount(); ++colIx) {
            EncodedColumnBatch.ColumnStreamData[] datas;
            if (!ecb.hasData(colIx)) continue;
            for (EncodedColumnBatch.ColumnStreamData data : datas = ecb.getColumnData(colIx)) {
                if (data == null || data.decRef() != 0) continue;
                if (LlapIoImpl.LOCKING_LOGGER.isTraceEnabled()) {
                    for (MemoryBuffer buf : data.getCacheBuffers()) {
                        LlapIoImpl.LOCKING_LOGGER.trace("Unlocking {} at the end of processing", (Object)buf);
                    }
                }
                this.bufferManager.decRefBuffers(data.getCacheBuffers());
                if (!this.useObjectPools) continue;
                CSD_POOL.offer((Object)data);
            }
        }
        if (this.useObjectPools) {
            ECB_POOL.offer((Object)ecb);
        }
    }

    @Override
    public TezCounters getTezCounters() {
        return this.counters.getTezCounters();
    }

    private static class FileReaderYieldReturn {
        private ReaderWithOffsets offsetReader;
        private int rowsPerSlice = 0;
        private long currentKnownTornStart;
        private long lastStartOffset = Long.MIN_VALUE;
        private long firstStartOffset = Long.MIN_VALUE;
        private boolean hasAnyData = false;
        private final EncodingWriter writer;
        private final boolean maySplitTheSplit;
        private final int targetSliceRowCount;
        private final FileSplit split;

        public FileReaderYieldReturn(ReaderWithOffsets offsetReader, FileSplit split, EncodingWriter writer, boolean maySplitTheSplit, int targetSliceRowCount) {
            Preconditions.checkNotNull((Object)offsetReader);
            this.offsetReader = offsetReader;
            this.currentKnownTornStart = split.getStart();
            this.writer = writer;
            this.maySplitTheSplit = maySplitTheSplit;
            this.targetSliceRowCount = targetSliceRowCount;
            this.split = split;
        }

        public CacheWriter getCacheWriter() throws IOException {
            return this.writer.getCacheWriter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Vectors readNextSlice() throws IOException {
            if (this.offsetReader == null) {
                return null;
            }
            try {
                while (this.offsetReader.next()) {
                    this.hasAnyData = true;
                    Writable value = this.offsetReader.getCurrentRow();
                    this.lastStartOffset = this.offsetReader.getCurrentRowStartOffset();
                    if (this.firstStartOffset == Long.MIN_VALUE) {
                        this.firstStartOffset = this.lastStartOffset;
                    }
                    this.writer.writeOneRow(value);
                    if (!this.maySplitTheSplit || ++this.rowsPerSlice != this.targetSliceRowCount) continue;
                    assert (this.offsetReader.hasOffsets());
                    this.writer.flushIntermediateData();
                    long fileOffset = this.offsetReader.getCurrentRowEndOffset();
                    if (this.firstStartOffset < 0L) throw new AssertionError((Object)("Unable to get offsets from " + this.offsetReader.getClass().getSimpleName()));
                    if (this.lastStartOffset < 0L) throw new AssertionError((Object)("Unable to get offsets from " + this.offsetReader.getClass().getSimpleName()));
                    if (fileOffset < 0L) {
                        throw new AssertionError((Object)("Unable to get offsets from " + this.offsetReader.getClass().getSimpleName()));
                    }
                    this.writer.setCurrentStripeOffsets(this.currentKnownTornStart, this.firstStartOffset, this.lastStartOffset, fileOffset);
                    this.writer.writeIntermediateFooter();
                    this.currentKnownTornStart = this.lastStartOffset;
                    this.lastStartOffset = Long.MIN_VALUE;
                    this.firstStartOffset = Long.MIN_VALUE;
                    this.rowsPerSlice = 0;
                    return new Vectors(this.writer.extractCurrentVrbs());
                }
                try {
                    if (this.rowsPerSlice > 0 || !this.maySplitTheSplit && this.hasAnyData) {
                        long fileOffset = -1L;
                        if (!this.offsetReader.hasOffsets()) {
                            this.firstStartOffset = this.split.getStart() + 1L;
                            this.lastStartOffset = this.split.getStart() + this.split.getLength();
                            fileOffset = this.lastStartOffset + 1L;
                            if (LlapIoImpl.CACHE_LOGGER.isDebugEnabled()) {
                                LlapIoImpl.CACHE_LOGGER.debug("Cache offsets based on the split - 'first row' at " + this.firstStartOffset + "; 'last row' at " + this.lastStartOffset + ", " + fileOffset);
                            }
                        } else {
                            fileOffset = this.offsetReader.getCurrentRowEndOffset();
                            if (!$assertionsDisabled) {
                                if (this.firstStartOffset < 0L) throw new AssertionError();
                                if (this.lastStartOffset < 0L) throw new AssertionError();
                                if (fileOffset < 0L) {
                                    throw new AssertionError();
                                }
                            }
                        }
                        this.writer.setCurrentStripeOffsets(this.currentKnownTornStart, this.firstStartOffset, this.lastStartOffset, fileOffset);
                        this.writer.close();
                        Vectors vectors = new Vectors(this.writer.extractCurrentVrbs());
                        return vectors;
                    }
                    this.writer.close();
                    Vectors fileOffset = null;
                    return fileOffset;
                }
                finally {
                    this.closeOffsetReader();
                }
            }
            catch (Exception ex) {
                IOException iOException;
                this.closeOffsetReader();
                if (ex instanceof IOException) {
                    iOException = (IOException)ex;
                    throw iOException;
                }
                iOException = new IOException(ex);
                throw iOException;
            }
        }

        private void closeOffsetReader() {
            if (this.offsetReader == null) {
                return;
            }
            try {
                this.offsetReader.close();
            }
            catch (Exception ex) {
                LlapIoImpl.LOG.error("Failed to close source reader", (Throwable)ex);
            }
            this.offsetReader = null;
        }
    }

    public static class CacheWriter
    implements PhysicalWriter {
        private CacheStripeData currentStripe;
        private final List<CacheStripeData> stripes = new ArrayList<CacheStripeData>();
        private final BufferUsageManager bufferManager;
        private final Allocator.BufferObjectFactory bufferFactory;
        private final List<Integer> columnIds;
        private final boolean[] writerIncludes;
        private final Map<StreamName, PhysicalWriter.OutputReceiver> streams = new HashMap<StreamName, PhysicalWriter.OutputReceiver>();
        private final Map<Integer, List<CacheOutputReceiver>> colStreams = new HashMap<Integer, List<CacheOutputReceiver>>();
        private final boolean doesSourceHaveIncludes;
        private final StreamOptions options;
        private final AtomicBoolean isStopped;
        private static final int ORC_MAX_BUFFER_BYTES = 0x7FFFFF;

        public CacheWriter(BufferUsageManager bufferManager, List<Integer> columnIds, boolean[] writerIncludes, boolean doesSourceHaveIncludes, Allocator.BufferObjectFactory bufferFactory, AtomicBoolean isStopped) {
            this.bufferManager = bufferManager;
            assert (writerIncludes != null);
            this.writerIncludes = writerIncludes;
            this.doesSourceHaveIncludes = doesSourceHaveIncludes;
            this.columnIds = columnIds;
            this.bufferFactory = bufferFactory;
            this.isStopped = isStopped;
            int orcAllocSize = Math.min(bufferManager.getAllocator().getMaxAllocation(), 0x7FFFFF);
            this.options = new StreamOptions(orcAllocSize);
            this.startStripe();
        }

        private void startStripe() {
            if (this.currentStripe != null) {
                this.stripes.add(this.currentStripe);
            }
            this.currentStripe = new CacheStripeData();
        }

        public void writeFileMetadata(OrcProto.Metadata.Builder builder) throws IOException {
        }

        public void writeFileFooter(OrcProto.Footer.Builder builder) throws IOException {
            OrcProto.Footer footer = builder.build();
            this.validateIncludes(footer);
        }

        public void validateIncludes(OrcProto.Footer footer) throws IOException {
            int i;
            boolean[] translatedIncludes;
            if (this.doesSourceHaveIncludes) {
                return;
            }
            boolean[] blArray = translatedIncludes = this.columnIds == null ? null : OrcInputFormat.genIncludedColumns((TypeDescription)OrcUtils.convertTypeFromProtobuf((List)footer.getTypesList(), (int)0), this.columnIds);
            if (translatedIncludes == null) {
                this.throwIncludesMismatchError(translatedIncludes);
            }
            int len = Math.min(translatedIncludes.length, this.writerIncludes.length);
            for (i = 0; i < len; ++i) {
                if (translatedIncludes[i] || !this.writerIncludes[i]) continue;
                this.throwIncludesMismatchError(translatedIncludes);
            }
            if (translatedIncludes.length < this.writerIncludes.length) {
                for (i = len; i < this.writerIncludes.length; ++i) {
                    if (!this.writerIncludes[i]) continue;
                    this.throwIncludesMismatchError(translatedIncludes);
                }
            }
        }

        private String throwIncludesMismatchError(boolean[] translated) throws IOException {
            String s = "Includes derived from the original table: " + DebugUtils.toString((boolean[])this.writerIncludes) + " but the ones derived from writer types are: " + DebugUtils.toString((boolean[])translated);
            LlapIoImpl.LOG.error(s);
            throw new IOException(s);
        }

        public long writePostScript(OrcProto.PostScript.Builder builder) {
            return 0L;
        }

        public void close() throws IOException {
        }

        public void discardData() {
            LlapIoImpl.LOG.debug("Discarding disk data (if any wasn't cached)");
            for (CacheStripeData stripe : this.stripes) {
                if (stripe.colStreams == null || stripe.colStreams.isEmpty()) continue;
                for (List<CacheStreamData> streams : stripe.colStreams.values()) {
                    for (CacheStreamData cos : streams) {
                        for (MemoryBuffer buffer : cos.data) {
                            if (LlapIoImpl.CACHE_LOGGER.isTraceEnabled()) {
                                LlapIoImpl.CACHE_LOGGER.trace("Deallocating " + String.valueOf(buffer));
                            }
                            this.bufferManager.getAllocator().deallocate(buffer);
                        }
                    }
                }
                stripe.colStreams.clear();
            }
        }

        public PhysicalWriter.OutputReceiver createDataStream(StreamName name) throws IOException {
            PhysicalWriter.OutputReceiver or = this.streams.get(name);
            if (or != null) {
                return or;
            }
            if (this.isNeeded(name)) {
                if (LlapIoImpl.LOG.isTraceEnabled()) {
                    LlapIoImpl.LOG.trace("Creating cache receiver for " + String.valueOf(name));
                }
                CacheOutputReceiver cor = new CacheOutputReceiver(this.bufferManager, name, this.bufferFactory, this.isStopped);
                or = cor;
                List<CacheOutputReceiver> list = this.colStreams.get(name.getColumn());
                if (list == null) {
                    list = new ArrayList<CacheOutputReceiver>();
                    this.colStreams.put(name.getColumn(), list);
                }
                list.add(cor);
            } else {
                if (LlapIoImpl.LOG.isTraceEnabled()) {
                    LlapIoImpl.LOG.trace("Creating null receiver for " + String.valueOf(name));
                }
                or = new NullOutputReceiver(name);
            }
            this.streams.put(name, or);
            return or;
        }

        public void writeHeader() throws IOException {
        }

        public void writeIndex(StreamName name, OrcProto.RowIndex.Builder index) throws IOException {
        }

        public void writeBloomFilter(StreamName name, OrcProto.BloomFilterIndex.Builder bloom) throws IOException {
        }

        public void writeStatistics(StreamName streamName, OrcProto.ColumnStatistics.Builder builder) throws IOException {
        }

        public void finalizeStripe(OrcProto.StripeFooter.Builder footer, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
            List allEnc = footer.getColumnsList();
            OrcProto.StripeInformation si = dirEntry.build();
            if (LlapIoImpl.LOG.isTraceEnabled()) {
                LlapIoImpl.LOG.trace(("Finalizing stripe " + String.valueOf(footer.build()) + " => " + String.valueOf(si)).replace('\n', ' '));
            }
            if (this.doesSourceHaveIncludes) {
                this.currentStripe.encodings = new ArrayList<OrcProto.ColumnEncoding>(this.writerIncludes.length);
                for (i = 0; i < this.writerIncludes.length; ++i) {
                    this.currentStripe.encodings.add(null);
                }
                this.currentStripe.encodings.set(0, (OrcProto.ColumnEncoding)allEnc.get(0));
                for (i = 1; i < allEnc.size(); ++i) {
                    int colIx = this.getSparseOrcIndexFromDenseDest(i);
                    this.currentStripe.encodings.set(colIx, (OrcProto.ColumnEncoding)allEnc.get(i));
                }
            } else {
                this.currentStripe.encodings = new ArrayList<OrcProto.ColumnEncoding>(allEnc);
                for (i = 0; i < this.currentStripe.encodings.size(); ++i) {
                    if (this.writerIncludes[i]) continue;
                    this.currentStripe.encodings.set(i, null);
                }
            }
            this.currentStripe.rowCount = si.getNumberOfRows();
            for (Map.Entry<Integer, List<CacheOutputReceiver>> e : this.colStreams.entrySet()) {
                int colIx = e.getKey();
                List<CacheOutputReceiver> streams = e.getValue();
                ArrayList<CacheStreamData> data = new ArrayList<CacheStreamData>(streams.size());
                for (CacheOutputReceiver receiver : streams) {
                    List<MemoryBuffer> buffers = receiver.buffers;
                    if (buffers == null) {
                        LlapIoImpl.LOG.debug("Buffers are null for " + String.valueOf(receiver.name));
                    }
                    data.add(new CacheStreamData(receiver.suppressed, receiver.name, buffers == null ? new ArrayList<MemoryBuffer>() : new ArrayList<MemoryBuffer>(buffers)));
                    receiver.clear();
                }
                if (this.doesSourceHaveIncludes && colIx > 0) {
                    int newColIx = this.getSparseOrcIndexFromDenseDest(colIx);
                    if (LlapIoImpl.LOG.isTraceEnabled()) {
                        LlapIoImpl.LOG.trace("Mapping the ORC writer column " + colIx + " to " + newColIx);
                    }
                    colIx = newColIx;
                }
                this.currentStripe.colStreams.put(colIx, data);
            }
            this.startStripe();
        }

        private int getSparseOrcIndexFromDenseDest(int denseColIx) {
            return this.columnIds.get(denseColIx - 1) + 1;
        }

        private boolean isNeeded(StreamName name) {
            return this.doesSourceHaveIncludes || this.writerIncludes[name.getColumn()];
        }

        public void flush() throws IOException {
        }

        public void appendRawStripe(ByteBuffer stripe, OrcProto.StripeInformation.Builder dirEntry) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setCurrentStripeOffsets(long currentKnownTornStart, long firstStartOffset, long lastStartOffset, long currentFileOffset) {
            this.currentStripe.knownTornStart = currentKnownTornStart;
            this.currentStripe.firstRowStart = firstStartOffset;
            this.currentStripe.lastRowStart = lastStartOffset;
            this.currentStripe.lastRowEnd = currentFileOffset;
        }

        public StreamOptions getStreamOptions() {
            return this.options;
        }

        public long getFileBytes(int column, WriterEncryptionVariant writerEncryptionVariant) {
            long size = 0L;
            List<CacheOutputReceiver> l = this.colStreams.get(column);
            if (l == null) {
                return size;
            }
            for (CacheOutputReceiver c : l) {
                if (c.getData() == null || c.suppressed || c.getName().getArea() == StreamName.Area.INDEX) continue;
                for (MemoryBuffer buffer : c.getData()) {
                    size += (long)buffer.getByteBufferRaw().limit();
                }
            }
            return size;
        }

        private static class CacheStripeData {
            private List<OrcProto.ColumnEncoding> encodings;
            private long rowCount = -1L;
            private long knownTornStart;
            private long firstRowStart;
            private long lastRowStart;
            private long lastRowEnd;
            private Map<Integer, List<CacheStreamData>> colStreams = new HashMap<Integer, List<CacheStreamData>>();

            private CacheStripeData() {
            }

            public String toString() {
                return ("{disk data knownTornStart=" + this.knownTornStart + ", firstRowStart=" + this.firstRowStart + ", lastRowStart=" + this.lastRowStart + ", lastRowEnd=" + this.lastRowEnd + ", rowCount=" + this.rowCount + ", encodings=" + String.valueOf(this.encodings) + ", streams=" + String.valueOf(this.colStreams) + "}").replace('\n', ' ');
            }

            public String toCoordinateString() {
                return "knownTornStart=" + this.knownTornStart + ", firstRowStart=" + this.firstRowStart + ", lastRowStart=" + this.lastRowStart + ", lastRowEnd=" + this.lastRowEnd;
            }
        }

        private static class CacheStreamData {
            private final List<MemoryBuffer> data;
            private final boolean isSuppressed;
            private final StreamName name;

            public CacheStreamData(boolean isSuppressed, StreamName name, List<MemoryBuffer> data) {
                this.isSuppressed = isSuppressed;
                this.name = name;
                this.data = data;
            }

            public String toString() {
                return "CacheStreamData [name=" + String.valueOf(this.name) + ", isSuppressed=" + this.isSuppressed + ", data=" + CacheStreamData.toString(this.data) + "]";
            }

            private static String toString(List<MemoryBuffer> data) {
                Object s = "";
                for (MemoryBuffer buffer : data) {
                    s = (String)s + String.valueOf(buffer) + ", ";
                }
                return s;
            }
        }
    }

    private static class Vectors {
        private final List<ColumnVector>[] data;
        private final boolean isSupported;
        private final long rowCount;

        public Vectors(List<VectorizedRowBatch> vrbs) {
            if (vrbs == null) {
                this.isSupported = false;
                this.data = null;
                this.rowCount = 0L;
                return;
            }
            this.isSupported = true;
            if (vrbs.isEmpty()) {
                this.data = null;
                this.rowCount = 0L;
                return;
            }
            this.data = new List[vrbs.get((int)0).numCols];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = new ArrayList<ColumnVector>(vrbs.size());
            }
            int rowCount = 0;
            for (VectorizedRowBatch vrb : vrbs) {
                assert (!vrb.selectedInUse);
                rowCount += vrb.size;
                for (int i = 0; i < vrb.cols.length; ++i) {
                    this.data[i].add(vrb.cols[i]);
                }
            }
            this.rowCount = rowCount;
        }

        public List<ColumnVector> getVectors(int ix) {
            return this.data[ix];
        }

        public long getRowCount() {
            return this.rowCount;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        public String toString() {
            return "Vectors {isSupported=" + this.isSupported + ", rowCount=" + this.rowCount + ", data=" + Arrays.toString(this.data) + "}";
        }
    }

    static interface ReaderWithOffsets {
        public boolean next() throws IOException;

        public Writable getCurrentRow();

        public void close() throws IOException;

        public boolean hasOffsets();

        public long getCurrentRowStartOffset();

        public long getCurrentRowEndOffset();
    }

    static abstract class EncodingWriter {
        protected Writer orcWriter;
        protected CacheWriter cacheWriter;
        protected final StructObjectInspector sourceOi;
        private final int allocSize;

        public EncodingWriter(StructObjectInspector sourceOi, int allocSize) {
            this.sourceOi = sourceOi;
            this.allocSize = allocSize;
        }

        public void init(CacheWriter cacheWriter, Configuration conf, Path path) throws IOException {
            this.orcWriter = this.createOrcWriter(cacheWriter, conf, path, this.sourceOi);
            this.cacheWriter = cacheWriter;
        }

        public CacheWriter getCacheWriter() {
            return this.cacheWriter;
        }

        public abstract boolean isOnlyWritingIncludedColumns();

        public abstract void writeOneRow(Writable var1) throws IOException;

        public abstract void setCurrentStripeOffsets(long var1, long var3, long var5, long var7);

        public abstract void flushIntermediateData() throws IOException;

        public abstract void writeIntermediateFooter() throws IOException;

        public abstract List<VectorizedRowBatch> extractCurrentVrbs();

        public void close() throws IOException {
            if (this.orcWriter != null) {
                try {
                    this.orcWriter.close();
                    this.orcWriter = null;
                }
                catch (Exception ex) {
                    LlapIoImpl.LOG.error("Failed to close ORC writer", (Throwable)ex);
                }
            }
            if (this.cacheWriter != null) {
                try {
                    this.cacheWriter.discardData();
                    this.cacheWriter = null;
                }
                catch (Exception ex) {
                    LlapIoImpl.LOG.error("Failed to close cache writer", (Throwable)ex);
                }
            }
        }

        protected Writer createOrcWriter(CacheWriter cacheWriter, Configuration conf, Path path, StructObjectInspector oi) throws IOException {
            return OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)SerDeEncodedDataReader.createOrcWriterOptions((ObjectInspector)oi, conf, cacheWriter, this.allocSize));
        }
    }

    private class AsyncCacheDataCallback
    implements VectorDeserializeOrcWriter.AsyncCallback {
        private AsyncCacheDataCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete(VectorDeserializeOrcWriter writer) {
            CacheWriter cacheWriter = null;
            try {
                cacheWriter = writer.getCacheWriter();
                boolean[] cacheIncludes = writer.getOriginalCacheIncludes();
                Iterator<CacheWriter.CacheStripeData> iter = cacheWriter.stripes.iterator();
                while (iter.hasNext()) {
                    SerDeEncodedDataReader.this.processAsyncCacheData(iter.next(), cacheIncludes);
                    iter.remove();
                }
            }
            catch (IOException e) {
                LlapIoImpl.LOG.error("Failed to cache async data", (Throwable)e);
            }
            finally {
                cacheWriter.discardData();
            }
        }
    }

    private static final class NoopMemoryManager
    extends org.apache.orc.impl.MemoryManager {
        public NoopMemoryManager() {
            super(null);
        }

        public void addedRow(int rows) {
        }

        public void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) {
        }

        public void notifyWriters() {
        }

        public void removeWriter(Path path) throws IOException {
        }
    }

    static class DeserializerOrcWriter
    extends EncodingWriter {
        private final Deserializer sourceSerDe;

        public DeserializerOrcWriter(Deserializer sourceSerDe, StructObjectInspector sourceOi, int allocSize) {
            super(sourceOi, allocSize);
            this.sourceSerDe = sourceSerDe;
        }

        @Override
        public void close() throws IOException {
            this.orcWriter.close();
        }

        @Override
        public void writeOneRow(Writable value) throws IOException {
            Object row = null;
            try {
                row = this.sourceSerDe.deserialize(value);
            }
            catch (SerDeException e) {
                throw new IOException(e);
            }
            this.orcWriter.addRow(row);
        }

        @Override
        public void flushIntermediateData() {
        }

        @Override
        public void writeIntermediateFooter() throws IOException {
            this.orcWriter.writeIntermediateFooter();
        }

        @Override
        public boolean isOnlyWritingIncludedColumns() {
            return false;
        }

        @Override
        public void setCurrentStripeOffsets(long currentKnownTornStart, long firstStartOffset, long lastStartOffset, long fileOffset) {
            this.cacheWriter.setCurrentStripeOffsets(currentKnownTornStart, firstStartOffset, lastStartOffset, fileOffset);
        }

        @Override
        public List<VectorizedRowBatch> extractCurrentVrbs() {
            return null;
        }
    }

    private static class NullOutputReceiver
    implements PhysicalWriter.OutputReceiver {
        private final StreamName name;

        public NullOutputReceiver(StreamName name) {
            this.name = name;
        }

        public void output(ByteBuffer buffer) throws IOException {
        }

        public void suppress() {
        }
    }

    private static final class CacheOutputReceiver
    implements CacheOutput,
    PhysicalWriter.OutputReceiver {
        private final BufferUsageManager bufferManager;
        private final Allocator.BufferObjectFactory bufferFactory;
        private final StreamName name;
        private List<MemoryBuffer> buffers = null;
        private int lastBufferPos = -1;
        private boolean suppressed = false;
        private final AtomicBoolean isStopped;
        private final StoppableAllocator allocator;

        public CacheOutputReceiver(BufferUsageManager bufferManager, StreamName name, Allocator.BufferObjectFactory bufferFactory, AtomicBoolean isStopped) {
            this.bufferManager = bufferManager;
            this.bufferFactory = bufferFactory;
            Allocator alloc = bufferManager.getAllocator();
            this.allocator = alloc instanceof StoppableAllocator ? (StoppableAllocator)alloc : null;
            this.name = name;
            this.isStopped = isStopped;
        }

        public void clear() {
            this.buffers = null;
            this.lastBufferPos = -1;
            this.suppressed = false;
        }

        public void suppress() {
            this.suppressed = true;
            this.lastBufferPos = -1;
        }

        private void allocateMultiple(MemoryBuffer[] dest, int size) {
            if (this.allocator != null) {
                this.allocator.allocateMultiple(dest, size, this.bufferFactory, this.isStopped);
            } else {
                this.bufferManager.getAllocator().allocateMultiple(dest, size, this.bufferFactory);
            }
        }

        public void output(ByteBuffer buffer) throws IOException {
            boolean isNewBuffer;
            if (LlapIoImpl.LOG.isTraceEnabled()) {
                LlapIoImpl.LOG.trace(String.valueOf(this.name) + " receiving a buffer of size " + buffer.remaining());
            }
            int size = buffer.remaining();
            Buffer bb = null;
            if (this.buffers == null) {
                this.buffers = new ArrayList<MemoryBuffer>();
            }
            if (!this.buffers.isEmpty()) {
                MemoryBuffer lastBuffer = this.buffers.get(this.buffers.size() - 1);
                bb = lastBuffer.getByteBufferRaw();
                int written = this.lastBufferPos - bb.position();
                if (bb.remaining() - written < size) {
                    this.lastBufferPos = -1;
                    bb = null;
                }
            }
            boolean bl = isNewBuffer = this.lastBufferPos == -1;
            if (isNewBuffer) {
                MemoryBuffer[] dest = new MemoryBuffer[1];
                this.allocateMultiple(dest, size);
                SerDeLowLevelCacheImpl.LlapSerDeDataBuffer newBuffer = (SerDeLowLevelCacheImpl.LlapSerDeDataBuffer)dest[0];
                bb = newBuffer.getByteBufferRaw();
                this.lastBufferPos = bb.position();
                this.buffers.add(newBuffer);
            }
            int pos = bb.position();
            ((ByteBuffer)bb).position(this.lastBufferPos);
            ((ByteBuffer)bb).put(buffer);
            this.lastBufferPos = bb.position();
            ((ByteBuffer)bb).position(pos);
        }

        @Override
        public List<MemoryBuffer> getData() {
            return this.buffers;
        }

        @Override
        public StreamName getName() {
            return this.name;
        }
    }

    private static interface CacheOutput {
        public List<MemoryBuffer> getData();

        public StreamName getName();
    }
}

