/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@Metrics(about="LlapDaemon Cache Metrics", context="cache")
public class LlapDaemonCacheMetrics
implements MetricsSource {
    final String name;
    private String sessionId;
    private final MetricsRegistry registry;
    @Metric
    MutableCounterLong cacheReadRequests;
    @Metric
    MutableGaugeLong cacheCapacityTotal;
    @Metric
    MutableCounterLong cacheCapacityUsed;
    @Metric
    MutableCounterLong cacheRequestedBytes;
    @Metric
    MutableCounterLong cacheHitBytes;
    @Metric
    MutableCounterLong cacheAllocatedArena;
    @Metric
    MutableCounterLong cacheNumLockedBuffers;

    private LlapDaemonCacheMetrics(String name, String sessionId) {
        this.name = name;
        this.sessionId = sessionId;
        this.registry = new MetricsRegistry("LlapDaemonCacheRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static LlapDaemonCacheMetrics create(String displayName, String sessionId) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        return (LlapDaemonCacheMetrics)ms.register(displayName, null, (Object)new LlapDaemonCacheMetrics(displayName, sessionId));
    }

    public void setCacheCapacityTotal(long value) {
        this.cacheCapacityTotal.set(value);
    }

    public void incrCacheCapacityUsed(long delta) {
        this.cacheCapacityUsed.incr(delta);
    }

    public void incrCacheRequestedBytes(long delta) {
        this.cacheRequestedBytes.incr(delta);
    }

    public void incrCacheHitBytes(long delta) {
        this.cacheHitBytes.incr(delta);
    }

    public void incrCacheReadRequests() {
        this.cacheReadRequests.incr();
    }

    public void incrAllocatedArena() {
        this.cacheAllocatedArena.incr();
    }

    public void incrCacheNumLockedBuffers() {
        this.cacheNumLockedBuffers.incr();
    }

    public void decrCacheNumLockedBuffers() {
        this.cacheNumLockedBuffers.incr(-1L);
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    public long getCacheRequestedBytes() {
        return this.cacheRequestedBytes.value();
    }

    @VisibleForTesting
    public long getCacheHitBytes() {
        return this.cacheHitBytes.value();
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonCacheInfo.CacheMetrics).setContext("cache").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getCacheStats(rb);
    }

    private void getCacheStats(MetricsRecordBuilder rb) {
        float cacheHitRatio = this.cacheRequestedBytes.value() == 0L ? 0.0f : (float)this.cacheHitBytes.value() / (float)this.cacheRequestedBytes.value();
        long cacheCapacityRemaining = this.cacheCapacityTotal.value() - this.cacheCapacityUsed.value();
        float cacheRemainingPercent = this.cacheCapacityTotal.value() == 0L ? 0.0f : (float)cacheCapacityRemaining / (float)this.cacheCapacityTotal.value();
        rb.addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheCapacityRemaining, cacheCapacityRemaining).addGauge((MetricsInfo)LlapDaemonCacheInfo.CacheCapacityRemainingPercentage, cacheRemainingPercent).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheCapacityTotal, this.cacheCapacityTotal.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheCapacityUsed, this.cacheCapacityUsed.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheReadRequests, this.cacheReadRequests.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheRequestedBytes, this.cacheRequestedBytes.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheHitBytes, this.cacheHitBytes.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheAllocatedArena, this.cacheAllocatedArena.value()).addCounter((MetricsInfo)LlapDaemonCacheInfo.CacheNumLockedBuffers, this.cacheNumLockedBuffers.value()).addGauge((MetricsInfo)LlapDaemonCacheInfo.CacheHitRatio, cacheHitRatio);
    }
}

