/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hive.kudu.org.apache.kudu.ColumnTypeAttributes;
import org.apache.hive.kudu.org.apache.kudu.Common;
import org.apache.hive.kudu.org.apache.kudu.Compression;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnSchema {
    private final String name;
    private final Type type;
    private final boolean key;
    private final boolean keyUnique;
    private final boolean nullable;
    private final boolean immutable;
    private final boolean autoIncrementing;
    private final Object defaultValue;
    private final int desiredBlockSize;
    private final Encoding encoding;
    private final CompressionAlgorithm compressionAlgorithm;
    private final ColumnTypeAttributes typeAttributes;
    private final int typeSize;
    private final Common.DataType wireType;
    private final String comment;

    private ColumnSchema(String name, Type type, boolean key, boolean keyUnique, boolean nullable, boolean immutable, boolean autoIncrementing, Object defaultValue, int desiredBlockSize, Encoding encoding, CompressionAlgorithm compressionAlgorithm, ColumnTypeAttributes typeAttributes, Common.DataType wireType, String comment) {
        this.name = name;
        this.type = type;
        this.key = key;
        this.keyUnique = keyUnique;
        this.nullable = nullable;
        this.immutable = immutable;
        this.autoIncrementing = autoIncrementing;
        this.defaultValue = defaultValue;
        this.desiredBlockSize = desiredBlockSize;
        this.encoding = encoding;
        this.compressionAlgorithm = compressionAlgorithm;
        this.typeAttributes = typeAttributes;
        this.typeSize = type.getSize(typeAttributes);
        this.wireType = wireType;
        this.comment = comment;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isKey() {
        return this.key;
    }

    public boolean isKeyUnique() {
        return this.keyUnique;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public boolean isAutoIncrementing() {
        return this.autoIncrementing;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public int getDesiredBlockSize() {
        return this.desiredBlockSize;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public ColumnTypeAttributes getTypeAttributes() {
        return this.typeAttributes;
    }

    @InterfaceAudience.Private
    public Common.DataType getWireType() {
        return this.wireType;
    }

    public int getTypeSize() {
        return this.typeSize;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnSchema)) {
            return false;
        }
        ColumnSchema that = (ColumnSchema)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.key, that.key) && Objects.equals(this.keyUnique, that.keyUnique) && Objects.equals(this.autoIncrementing, that.autoIncrementing) && Objects.equals(this.typeAttributes, that.typeAttributes) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.key, this.typeAttributes, this.comment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Column name: ");
        sb.append(this.name);
        sb.append(", type: ");
        sb.append(this.type.getName());
        if (this.typeAttributes != null) {
            sb.append(this.typeAttributes.toStringForType(this.type));
        }
        if (!this.comment.isEmpty()) {
            sb.append(", comment: ");
            sb.append(this.comment);
        }
        return sb.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class AutoIncrementingColumnSchemaBuilder {
        private final String name = Schema.getAutoIncrementingColumnName();
        private final Type type = Schema.getAutoIncrementingColumnType();
        private int desiredBlockSize = 0;
        private Encoding encoding = null;
        private CompressionAlgorithm compressionAlgorithm = null;
        private Common.DataType wireType = null;
        private String comment = "";

        public AutoIncrementingColumnSchemaBuilder desiredBlockSize(int desiredBlockSize) {
            this.desiredBlockSize = desiredBlockSize;
            return this;
        }

        public AutoIncrementingColumnSchemaBuilder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public AutoIncrementingColumnSchemaBuilder compressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        @InterfaceAudience.Private
        public AutoIncrementingColumnSchemaBuilder wireType(Common.DataType wireType) {
            this.wireType = wireType;
            return this;
        }

        public AutoIncrementingColumnSchemaBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ColumnSchema build() {
            if (this.wireType == null) {
                this.wireType = this.type.getDataType(null);
            }
            return new ColumnSchema(this.name, this.type, true, false, false, false, true, null, this.desiredBlockSize, this.encoding, this.compressionAlgorithm, null, this.wireType, this.comment);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class ColumnSchemaBuilder {
        private static final List<Type> TYPES_WITH_ATTRIBUTES = Arrays.asList(Type.DECIMAL, Type.VARCHAR);
        private final String name;
        private final Type type;
        private boolean key = false;
        private boolean keyUnique = false;
        private boolean nullable = false;
        private boolean immutable = false;
        private Object defaultValue = null;
        private int desiredBlockSize = 0;
        private Encoding encoding = null;
        private CompressionAlgorithm compressionAlgorithm = null;
        private ColumnTypeAttributes typeAttributes = null;
        private Common.DataType wireType = null;
        private String comment = "";

        public ColumnSchemaBuilder(String name, Type type) {
            if (name.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
                throw new IllegalArgumentException("Column name " + Schema.getAutoIncrementingColumnName() + " is reserved by Kudu engine");
            }
            this.name = name;
            this.type = type;
        }

        public ColumnSchemaBuilder(ColumnSchema that) {
            this.name = that.name;
            this.type = that.type;
            this.key = that.key;
            this.keyUnique = that.keyUnique;
            this.nullable = that.nullable;
            this.immutable = that.immutable;
            this.defaultValue = that.defaultValue;
            this.desiredBlockSize = that.desiredBlockSize;
            this.encoding = that.encoding;
            this.compressionAlgorithm = that.compressionAlgorithm;
            this.typeAttributes = that.typeAttributes;
            this.wireType = that.wireType;
            this.comment = that.comment;
        }

        public ColumnSchemaBuilder key(boolean key) {
            this.key = key;
            this.keyUnique = key;
            return this;
        }

        public ColumnSchemaBuilder nonUniqueKey(boolean key) {
            this.key = key;
            this.keyUnique = false;
            return this;
        }

        public ColumnSchemaBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnSchemaBuilder immutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public ColumnSchemaBuilder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColumnSchemaBuilder desiredBlockSize(int desiredBlockSize) {
            this.desiredBlockSize = desiredBlockSize;
            return this;
        }

        public ColumnSchemaBuilder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public ColumnSchemaBuilder compressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public ColumnSchemaBuilder typeAttributes(ColumnTypeAttributes typeAttributes) {
            if (typeAttributes != null && !TYPES_WITH_ATTRIBUTES.contains((Object)this.type)) {
                throw new IllegalArgumentException("ColumnTypeAttributes are not used on " + (Object)((Object)this.type) + " columns");
            }
            this.typeAttributes = typeAttributes;
            return this;
        }

        @InterfaceAudience.Private
        public ColumnSchemaBuilder wireType(Common.DataType wireType) {
            this.wireType = wireType;
            return this;
        }

        public ColumnSchemaBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public ColumnSchema build() {
            if (this.wireType == null) {
                this.wireType = this.type.getDataType(this.typeAttributes);
            }
            if (!(this.type != Type.VARCHAR || this.typeAttributes != null && this.typeAttributes.hasLength() && this.typeAttributes.getLength() >= 1 && this.typeAttributes.getLength() <= 65535)) {
                throw new IllegalArgumentException(String.format("VARCHAR's length must be set and between %d and %d", 1, 65535));
            }
            return new ColumnSchema(this.name, this.type, this.key, this.keyUnique, this.nullable, this.immutable, false, this.defaultValue, this.desiredBlockSize, this.encoding, this.compressionAlgorithm, this.typeAttributes, this.wireType, this.comment);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum CompressionAlgorithm {
        UNKNOWN(Compression.CompressionType.UNKNOWN_COMPRESSION),
        DEFAULT_COMPRESSION(Compression.CompressionType.DEFAULT_COMPRESSION),
        NO_COMPRESSION(Compression.CompressionType.NO_COMPRESSION),
        SNAPPY(Compression.CompressionType.SNAPPY),
        LZ4(Compression.CompressionType.LZ4),
        ZLIB(Compression.CompressionType.ZLIB);

        final Compression.CompressionType internalPbType;

        private CompressionAlgorithm(Compression.CompressionType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Compression.CompressionType getInternalPbType() {
            return this.internalPbType;
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum Encoding {
        UNKNOWN(Common.EncodingType.UNKNOWN_ENCODING),
        AUTO_ENCODING(Common.EncodingType.AUTO_ENCODING),
        PLAIN_ENCODING(Common.EncodingType.PLAIN_ENCODING),
        PREFIX_ENCODING(Common.EncodingType.PREFIX_ENCODING),
        GROUP_VARINT(Common.EncodingType.GROUP_VARINT),
        RLE(Common.EncodingType.RLE),
        DICT_ENCODING(Common.EncodingType.DICT_ENCODING),
        BIT_SHUFFLE(Common.EncodingType.BIT_SHUFFLE);

        final Common.EncodingType internalPbType;

        private Encoding(Common.EncodingType internalPbType) {
            this.internalPbType = internalPbType;
        }

        @InterfaceAudience.Private
        public Common.EncodingType getInternalPbType() {
            return this.internalPbType;
        }
    }
}

