/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu;

import java.util.Objects;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnTypeAttributes {
    private final boolean hasPrecision;
    private final int precision;
    private final boolean hasScale;
    private final int scale;
    private final boolean hasLength;
    private final int length;

    private ColumnTypeAttributes(boolean hasPrecision, int precision, boolean hasScale, int scale, boolean hasLength, int length) {
        this.hasPrecision = hasPrecision;
        this.precision = precision;
        this.hasScale = hasScale;
        this.scale = scale;
        this.hasLength = hasLength;
        this.length = length;
    }

    public boolean hasPrecision() {
        return this.hasPrecision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean hasScale() {
        return this.hasScale;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean hasLength() {
        return this.hasLength;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnTypeAttributes)) {
            return false;
        }
        ColumnTypeAttributes that = (ColumnTypeAttributes)o;
        if (this.hasPrecision != that.hasPrecision) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.hasScale != that.hasScale) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (this.hasLength != that.hasLength) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        return Objects.hash(this.hasPrecision, this.precision, this.hasScale, this.scale, this.hasLength, this.length);
    }

    public String toStringForType(Type type) {
        if (type == Type.DECIMAL) {
            return "(" + this.precision + ", " + this.scale + ")";
        }
        if (type == Type.VARCHAR) {
            return "(" + this.length + ")";
        }
        return "";
    }

    public String toString() {
        return "hasPrecision: " + this.hasPrecision + ", precision: " + this.precision + ", hasScale: " + this.hasScale + ", scale: " + this.scale + ", hasLength: " + this.hasLength + ", length: " + this.length;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class ColumnTypeAttributesBuilder {
        private boolean hasPrecision;
        private int precision;
        private boolean hasScale;
        private int scale;
        private boolean hasLength;
        private int length;

        public ColumnTypeAttributesBuilder precision(int precision) {
            this.hasPrecision = true;
            this.precision = precision;
            return this;
        }

        public ColumnTypeAttributesBuilder scale(int scale) {
            this.hasScale = true;
            this.scale = scale;
            return this;
        }

        public ColumnTypeAttributesBuilder length(int length) {
            this.hasLength = true;
            this.length = length;
            return this;
        }

        public ColumnTypeAttributes build() {
            return new ColumnTypeAttributes(this.hasPrecision, this.precision, this.hasScale, this.scale, this.hasLength, this.length);
        }
    }
}

