/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.kudu.com.stumbleupon.async.Callback;
import org.apache.hive.kudu.com.stumbleupon.async.Deferred;
import org.apache.hive.kudu.org.apache.kudu.client.AbortTransactionRequest;
import org.apache.hive.kudu.org.apache.kudu.client.AbortTransactionResponse;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduSession;
import org.apache.hive.kudu.org.apache.kudu.client.BeginTransactionRequest;
import org.apache.hive.kudu.org.apache.kudu.client.BeginTransactionResponse;
import org.apache.hive.kudu.org.apache.kudu.client.CommitTransactionRequest;
import org.apache.hive.kudu.org.apache.kudu.client.CommitTransactionResponse;
import org.apache.hive.kudu.org.apache.kudu.client.GetTransactionStateRequest;
import org.apache.hive.kudu.org.apache.kudu.client.GetTransactionStateResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KeepTransactionAliveRequest;
import org.apache.hive.kudu.org.apache.kudu.client.KeepTransactionAliveResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.KuduSession;
import org.apache.hive.kudu.org.apache.kudu.client.NonRecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.OperationResponse;
import org.apache.hive.kudu.org.apache.kudu.client.RecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.Status;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timeout;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.TimerTask;
import org.apache.hive.kudu.org.apache.kudu.transactions.Transactions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduTransaction
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(KuduTransaction.class);
    private static final SerializationOptions defaultSerializationOptions = new SerializationOptions();
    private static final String ERRMSG_TXN_NOT_OPEN = "transaction is not open for this handle";
    private final AsyncKuduClient client;
    private long txnId = -1L;
    private int keepaliveMillis = 0;
    private boolean keepaliveEnabled = true;
    private boolean isInFlight = false;
    private final Object isInFlightSync = new Object();
    private Timeout keepaliveTaskHandle = null;
    private final Object keepaliveTaskHandleSync = new Object();
    private boolean isCommitStarted = false;
    private final Object isCommitStartedSync = new Object();
    private List<AsyncKuduSession> sessions = new ArrayList<AsyncKuduSession>();

    KuduTransaction(AsyncKuduClient client) {
        Preconditions.checkArgument(client != null);
        this.client = client;
    }

    KuduTransaction(AsyncKuduClient client, long txnId, int keepaliveMillis, boolean keepaliveEnabled) {
        Preconditions.checkArgument(client != null);
        Preconditions.checkArgument(txnId > -1L);
        Preconditions.checkArgument(keepaliveMillis >= 0);
        this.client = client;
        this.txnId = txnId;
        this.keepaliveMillis = keepaliveMillis;
        this.keepaliveEnabled = keepaliveEnabled;
        this.startKeepaliveHeartbeating();
        this.isInFlight = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin() throws KuduException {
        Object object = this.isInFlightSync;
        synchronized (object) {
            Preconditions.checkState(!this.isInFlight);
        }
        this.doBeginTransaction();
        this.startKeepaliveHeartbeating();
        object = this.isInFlightSync;
        synchronized (object) {
            this.isInFlight = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncKuduSession newAsyncKuduSession() {
        Object object = this.isInFlightSync;
        synchronized (object) {
            Preconditions.checkState(this.isInFlight, ERRMSG_TXN_NOT_OPEN);
        }
        AsyncKuduSession session = null;
        Object object2 = this.isCommitStartedSync;
        synchronized (object2) {
            Preconditions.checkState(!this.isCommitStarted, "commit already started");
            session = this.client.newTransactionalSession(this.txnId);
            this.sessions.add(session);
        }
        Preconditions.checkNotNull(session);
        return session;
    }

    public KuduSession newKuduSession() {
        return new KuduSession(this.newAsyncKuduSession());
    }

    public void commit() throws KuduException {
        this.commitWithMode(CommitMode.WAIT_FOR_COMPLETION);
    }

    public void startCommit() throws KuduException {
        this.commitWithMode(CommitMode.START_ONLY);
    }

    public boolean isCommitComplete() throws KuduException {
        Deferred<GetTransactionStateResponse> d = this.isTransactionCommittedAsync();
        GetTransactionStateResponse resp = KuduClient.joinAndHandleException(d);
        Transactions.TxnStatePB txnState = resp.txnState();
        if (resp.hasCommitTimestamp()) {
            this.client.updateLastPropagatedTimestamp(resp.getCommitTimestamp());
        }
        switch (txnState) {
            case ABORT_IN_PROGRESS: {
                throw new NonRecoverableException(Status.Aborted("transaction is being aborted"));
            }
            case ABORTED: {
                throw new NonRecoverableException(Status.Aborted("transaction was aborted"));
            }
            case OPEN: {
                throw new NonRecoverableException(Status.IllegalState("transaction is still open"));
            }
            case COMMITTED: {
                return true;
            }
            case FINALIZE_IN_PROGRESS: 
            case COMMIT_IN_PROGRESS: {
                return false;
            }
        }
        throw new NonRecoverableException(Status.NotSupported("unexpected transaction state: " + txnState.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws KuduException {
        Preconditions.checkState(this.isInFlight, ERRMSG_TXN_NOT_OPEN);
        this.doRollbackTransaction();
        Object object = this.keepaliveTaskHandleSync;
        synchronized (object) {
            if (this.keepaliveTaskHandle != null) {
                LOG.debug("stopping keepalive heartbeating after rollback (txn ID {})", (Object)this.txnId);
                this.keepaliveTaskHandle.cancel();
            }
        }
        object = this.isInFlightSync;
        synchronized (object) {
            this.isInFlight = false;
        }
    }

    public byte[] serialize(SerializationOptions options) throws IOException {
        LOG.debug("serializing handle (txn ID {})", (Object)this.txnId);
        Preconditions.checkState(this.txnId != -1L, "invalid transaction handle");
        Transactions.TxnTokenPB.Builder b = Transactions.TxnTokenPB.newBuilder();
        b.setTxnId(this.txnId);
        b.setEnableKeepalive(options.isKeepaliveEnabled());
        b.setKeepaliveMillis(this.keepaliveMillis);
        Transactions.TxnTokenPB message = b.build();
        byte[] buf = new byte[message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public byte[] serialize() throws IOException {
        return this.serialize(defaultSerializationOptions);
    }

    public static KuduTransaction deserialize(byte[] buf, AsyncKuduClient client) throws IOException {
        Transactions.TxnTokenPB pb = Transactions.TxnTokenPB.parseFrom(CodedInputStream.newInstance(buf));
        long txnId = pb.getTxnId();
        int keepaliveMillis = pb.getKeepaliveMillis();
        boolean keepaliveEnabled = pb.hasEnableKeepalive() && pb.getEnableKeepalive();
        return new KuduTransaction(client, txnId, keepaliveMillis, keepaliveEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.keepaliveTaskHandleSync;
            synchronized (object) {
                if (this.keepaliveTaskHandle != null) {
                    LOG.debug("stopping keepalive heartbeating (txn ID {})", (Object)this.txnId);
                    this.keepaliveTaskHandle.cancel();
                }
            }
        }
        catch (Exception e) {
            LOG.error("exception while automatically rolling back a transaction", (Throwable)e);
        }
    }

    private void doBeginTransaction() throws KuduException {
        BeginTransactionRequest request = new BeginTransactionRequest(this.client.getMasterTable(), this.client.getTimer(), this.client.getDefaultAdminOperationTimeoutMs());
        Deferred<BeginTransactionResponse> d = this.client.sendRpcToTablet(request);
        BeginTransactionResponse resp = KuduClient.joinAndHandleException(d);
        this.txnId = resp.txnId();
        this.keepaliveMillis = resp.keepaliveMillis();
    }

    private void doRollbackTransaction() throws KuduException {
        AbortTransactionRequest request = new AbortTransactionRequest(this.client.getMasterTable(), this.client.getTimer(), this.client.getDefaultAdminOperationTimeoutMs(), this.txnId);
        Deferred<AbortTransactionResponse> d = this.client.sendRpcToTablet(request);
        KuduClient.joinAndHandleException(d);
    }

    private CommitTransactionRequest doCommitTransaction() throws KuduException {
        CommitTransactionRequest request = new CommitTransactionRequest(this.client.getMasterTable(), this.client.getTimer(), this.client.getDefaultAdminOperationTimeoutMs(), this.txnId);
        Deferred<CommitTransactionResponse> d = this.client.sendRpcToTablet(request);
        KuduClient.joinAndHandleException(d);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWithMode(CommitMode mode) throws KuduException {
        Iterator<AsyncKuduSession> iterator = this.isInFlightSync;
        synchronized (iterator) {
            Preconditions.checkState(this.isInFlight, ERRMSG_TXN_NOT_OPEN);
        }
        iterator = this.isCommitStartedSync;
        synchronized (iterator) {
            this.isCommitStarted = true;
        }
        for (AsyncKuduSession object : this.sessions) {
            if (mode == CommitMode.WAIT_FOR_COMPLETION) {
                List<OperationResponse> results = KuduClient.joinAndHandleException(object.flush());
                for (OperationResponse result : results) {
                    if (!result.hasRowError()) continue;
                    throw new NonRecoverableException(Status.Incomplete(String.format("failed to flush a transactional session: %s", result.getRowError().toString())));
                }
                continue;
            }
            if (!object.hasPendingOperations()) continue;
            throw new NonRecoverableException(Status.IllegalState("cannot start committing transaction: at least one transactional session has write operations pending"));
        }
        CommitTransactionRequest req = this.doCommitTransaction();
        Object object = this.keepaliveTaskHandleSync;
        synchronized (object) {
            if (this.keepaliveTaskHandle != null) {
                LOG.debug("stopping keepalive heartbeating after initiating commit (txn ID {})", (Object)this.txnId);
                this.keepaliveTaskHandle.cancel();
            }
        }
        if (mode == CommitMode.WAIT_FOR_COMPLETION) {
            Deferred<GetTransactionStateResponse> deferred = this.getDelayedIsTransactionCommittedDeferred(req);
            KuduClient.joinAndHandleException(deferred);
        }
        Object object2 = this.isInFlightSync;
        synchronized (object2) {
            this.isInFlight = false;
        }
    }

    private Deferred<GetTransactionStateResponse> isTransactionCommittedAsync() {
        GetTransactionStateRequest request = new GetTransactionStateRequest(this.client.getMasterTable(), this.client.getTimer(), this.client.getDefaultAdminOperationTimeoutMs(), this.txnId);
        return this.client.sendRpcToTablet(request);
    }

    Deferred<GetTransactionStateResponse> getDelayedIsTransactionCommittedDeferred(KuduRpc<?> parent) {
        KuduRpc<GetTransactionStateResponse> fakeRpc = this.client.buildFakeRpc("GetTransactionState", parent);
        Deferred<GetTransactionStateResponse> fakeRpcD = fakeRpc.getDeferred();
        this.delayedIsTransactionCommitted(fakeRpc, this.isTransactionCommittedCb(fakeRpc), this.isTransactionCommittedErrb(fakeRpc));
        return fakeRpcD;
    }

    private void delayedIsTransactionCommitted(KuduRpc<GetTransactionStateResponse> rpc, final Callback<Deferred<GetTransactionStateResponse>, GetTransactionStateResponse> callback, final Callback<Exception, Exception> errback) {
        long sleepTimeMillis = this.client.getSleepTimeForRpcMillis(rpc);
        if (rpc.timeoutTracker.wouldSleepingTimeoutMillis(sleepTimeMillis)) {
            AsyncKuduClient.tooManyAttemptsOrTimeout(rpc, null);
            return;
        }
        final class RetryTimer
        implements TimerTask {
            RetryTimer() {
            }

            @Override
            public void run(Timeout timeout) {
                KuduTransaction.this.isTransactionCommittedAsync().addCallbacks(callback, errback);
            }
        }
        AsyncKuduClient.newTimeout(this.client.getTimer(), new RetryTimer(), sleepTimeMillis);
    }

    private Callback<Deferred<GetTransactionStateResponse>, GetTransactionStateResponse> isTransactionCommittedCb(KuduRpc<GetTransactionStateResponse> rpc) {
        return resp -> {
            if (resp.hasCommitTimestamp()) {
                this.client.updateLastPropagatedTimestamp(resp.getCommitTimestamp());
            }
            Deferred d = rpc.getDeferred();
            if (resp.isCommitted()) {
                rpc.callback((GetTransactionStateResponse)resp);
            } else if (resp.isAborted()) {
                rpc.errback(new NonRecoverableException(Status.Aborted("transaction was aborted")));
            } else {
                ++rpc.attempt;
                this.delayedIsTransactionCommitted(rpc, this.isTransactionCommittedCb(rpc), this.isTransactionCommittedErrb(rpc));
            }
            return d;
        };
    }

    private <R> Callback<Exception, Exception> isTransactionCommittedErrb(KuduRpc<R> rpc) {
        return e -> {
            rpc.errback((Exception)e);
            return e;
        };
    }

    private static long keepalivePeriodForTimeout(long keepaliveMillis) {
        Preconditions.checkArgument(keepaliveMillis > 0L, "keepalive timeout must be a positive number");
        long period = keepaliveMillis / 2L;
        if (period <= 0L) {
            period = 1L;
        }
        return period;
    }

    private static long keepaliveRequestTimeout(long keepaliveMillis) {
        long timeout = KuduTransaction.keepalivePeriodForTimeout(keepaliveMillis) / 2L;
        if (timeout <= 0L) {
            timeout = 1L;
        }
        return timeout;
    }

    private void startKeepaliveHeartbeating() {
        if (this.keepaliveEnabled) {
            LOG.debug("starting keepalive heartbeating with period {} ms (txn ID {})", (Object)KuduTransaction.keepalivePeriodForTimeout(this.keepaliveMillis), (Object)this.txnId);
            this.doStartKeepaliveHeartbeating();
        } else {
            LOG.debug("keepalive heartbeating disabled for this handle (txn ID {})", (Object)this.txnId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStartKeepaliveHeartbeating() {
        Preconditions.checkState(this.keepaliveEnabled);
        Preconditions.checkArgument(this.txnId > -1L);
        Object object = this.keepaliveTaskHandleSync;
        synchronized (object) {
            Preconditions.checkState(this.keepaliveTaskHandle == null, "keepalive heartbeating has already started");
            long sleepTimeMillis = KuduTransaction.keepalivePeriodForTimeout(this.keepaliveMillis);
            this.keepaliveTaskHandle = this.delayedSendKeepTransactionAlive(sleepTimeMillis, this.getSendKeepTransactionAliveCB(), this.getSendKeepTransactionAliveEB());
        }
    }

    private Deferred<KeepTransactionAliveResponse> doSendKeepTransactionAlive() {
        long timeoutMs = KuduTransaction.keepaliveRequestTimeout(this.keepaliveMillis);
        KeepTransactionAliveRequest request = new KeepTransactionAliveRequest(this.client.getMasterTable(), this.client.getTimer(), timeoutMs, this.txnId);
        return this.client.sendRpcToTablet(request);
    }

    private Timeout delayedSendKeepTransactionAlive(long runAfterMillis, final Callback<Void, KeepTransactionAliveResponse> callback, final Callback<Void, Exception> errback) {
        final class RetryTimer
        implements TimerTask {
            RetryTimer() {
            }

            @Override
            public void run(Timeout timeout) {
                KuduTransaction.this.doSendKeepTransactionAlive().addCallbacks(callback, errback);
            }
        }
        return AsyncKuduClient.newTimeout(this.client.getTimer(), new RetryTimer(), runAfterMillis);
    }

    private Callback<Void, KeepTransactionAliveResponse> getSendKeepTransactionAliveCB() {
        long sleepTimeMillis = KuduTransaction.keepalivePeriodForTimeout(this.keepaliveMillis);
        return resp -> {
            Object object = this.keepaliveTaskHandleSync;
            synchronized (object) {
                if (!this.keepaliveTaskHandle.isCancelled()) {
                    this.keepaliveTaskHandle = this.delayedSendKeepTransactionAlive(sleepTimeMillis, this.getSendKeepTransactionAliveCB(), this.getSendKeepTransactionAliveEB());
                }
            }
            return null;
        };
    }

    private Callback<Void, Exception> getSendKeepTransactionAliveEB() {
        return e -> {
            boolean scheduleNextRun = false;
            long nextRunAfterMillis = -1L;
            if (e instanceof RecoverableException) {
                scheduleNextRun = true;
                nextRunAfterMillis = KuduTransaction.keepaliveRequestTimeout(this.keepaliveMillis);
                LOG.debug("continuing keepalive heartbeating (txn ID {}): {}", (Object)this.txnId, (Object)e.toString());
            } else if (e instanceof NonRecoverableException) {
                NonRecoverableException ex = (NonRecoverableException)e;
                if (ex.getStatus().isTimedOut()) {
                    scheduleNextRun = true;
                    nextRunAfterMillis = 1L;
                    LOG.debug("sending keepalive message after prior one timed out (txn ID {}): {}", (Object)this.txnId, (Object)e.toString());
                } else {
                    LOG.debug("terminating keepalive task (txn ID {}) due to exception {}", (Object)this.txnId, (Object)e.toString());
                }
            }
            if (scheduleNextRun) {
                Preconditions.checkArgument(nextRunAfterMillis >= 0L);
                Object object = this.keepaliveTaskHandleSync;
                synchronized (object) {
                    if (!this.keepaliveTaskHandle.isCancelled()) {
                        this.keepaliveTaskHandle = this.delayedSendKeepTransactionAlive(nextRunAfterMillis, this.getSendKeepTransactionAliveCB(), this.getSendKeepTransactionAliveEB());
                    }
                }
            }
            return null;
        };
    }

    private static enum CommitMode {
        START_ONLY,
        WAIT_FOR_COMPLETION;

    }

    public static class SerializationOptions {
        private boolean enableKeepalive = false;

        SerializationOptions() {
        }

        public boolean isKeepaliveEnabled() {
            return this.enableKeepalive;
        }

        public SerializationOptions setEnableKeepalive(boolean enableKeepalive) {
            this.enableKeepalive = enableKeepalive;
            return this;
        }
    }
}

