/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.concurrent.TimeUnit;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Stopwatch;

public class TimeoutTracker {
    private final Stopwatch stopwatch;
    private long timeout = 0L;

    public TimeoutTracker() {
        this(Stopwatch.createUnstarted());
    }

    public TimeoutTracker(Stopwatch stopwatch) {
        if (stopwatch.isRunning()) {
            stopwatch.reset();
        }
        this.stopwatch = stopwatch.start();
    }

    public boolean timedOut() {
        if (!this.hasTimeout()) {
            return false;
        }
        return this.timeout - this.stopwatch.elapsed(TimeUnit.MILLISECONDS) <= 0L;
    }

    public long getMillisBeforeTimeout() {
        if (!this.hasTimeout()) {
            throw new IllegalStateException("This tracker doesn't have a timeout set so it cannot answer getMillisBeforeTimeout()");
        }
        long millisBeforeTimeout = this.timeout - this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        millisBeforeTimeout = millisBeforeTimeout <= 0L ? 1L : millisBeforeTimeout;
        return millisBeforeTimeout;
    }

    public long getElapsedMillis() {
        return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    public boolean hasTimeout() {
        return this.timeout != 0L;
    }

    public boolean wouldSleepingTimeoutMillis(long plannedSleepTimeMillis) {
        if (!this.hasTimeout()) {
            return false;
        }
        return this.getMillisBeforeTimeout() - plannedSleepTimeMillis <= 0L;
    }

    public void reset() {
        this.timeout = 0L;
        this.stopwatch.reset();
        this.stopwatch.start();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout must be greater or equal to 0, the passed value is " + timeout);
        }
        this.timeout = timeout;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TimeoutTracker(timeout=");
        buf.append(this.timeout);
        buf.append(", elapsed=").append(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        buf.append(")");
        return buf.toString();
    }
}

