/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.util;

import java.util.concurrent.TimeUnit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HybridTimeUtil {
    public static final int hybridTimeNumBitsToShift = 12;
    public static final int hybridTimeLogicalBitsMask = 4095;

    private HybridTimeUtil() {
    }

    public static long clockTimestampToHTTimestamp(long timestamp, TimeUnit timeUnit) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be less than 0");
        }
        long timestampInMicros = TimeUnit.MICROSECONDS.convert(timestamp, timeUnit);
        return timestampInMicros << 12;
    }

    public static long[] HTTimestampToPhysicalAndLogical(long htTimestamp) {
        long timestampInMicros = htTimestamp >> 12;
        long logicalValues = htTimestamp & 0xFFFL;
        return new long[]{timestampInMicros, logicalValues};
    }

    public static long physicalAndLogicalToHTTimestamp(long physical, long logical) {
        return (physical << 12) + logical;
    }
}

