/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClient;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTokenLocalClientImpl
implements LlapTokenLocalClient {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTokenLocalClientImpl.class);
    private final SecretManager secretManager;

    public LlapTokenLocalClientImpl(Configuration conf, String clusterId) {
        this.secretManager = SecretManager.createSecretManager((Configuration)conf, (String)clusterId);
    }

    public Token<LlapTokenIdentifier> createToken(String appId, String user, boolean isSignatureRequired) throws IOException {
        try {
            Token token = this.secretManager.createLlapToken(appId, user, isSignatureRequired);
            LOG.info("Created a LLAP delegation token locally: {}", (Object)token);
            return token;
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
    }

    public void close() {
        try {
            this.secretManager.stopThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

