/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.rdbms.mapping.MappingCallbacks;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.types.containers.ContainerAdapter;
import org.datanucleus.store.types.containers.ElementContainerHandler;

public class SingleCollectionMapping
extends JavaTypeMapping
implements MappingCallbacks {
    private JavaTypeMapping wrappedMapping;
    private Class wrappedTypeClass;

    @Override
    public void initialize(AbstractMemberMetaData mmd, Table table, ClassLoaderResolver clr) {
        CollectionMetaData collectionMetaData = mmd.getCollection();
        String wrappedTypeName = collectionMetaData.getElementType();
        this.wrappedTypeClass = clr.classForName(wrappedTypeName);
        WrappedMemberMetaData wmmd = new WrappedMemberMetaData(mmd, this.wrappedTypeClass, clr);
        this.wrappedMapping = table.getStoreManager().getMappingManager().getMapping(table, wmmd, clr, FieldRole.ROLE_FIELD);
        super.initialize(mmd, table, clr);
    }

    @Override
    public void setMemberMetaData(AbstractMemberMetaData mmd) {
        super.setMemberMetaData(mmd);
        this.wrappedMapping.setMemberMetaData(new WrappedMemberMetaData(mmd, this.wrappedTypeClass, this.getStoreManager().getNucleusContext().getClassLoaderResolver(null)));
    }

    public JavaTypeMapping getWrappedMapping() {
        return this.wrappedMapping;
    }

    @Override
    public boolean includeInFetchStatement() {
        return this.wrappedMapping.includeInFetchStatement();
    }

    @Override
    public boolean hasSimpleDatastoreRepresentation() {
        return this.wrappedMapping == null ? false : this.wrappedMapping.hasSimpleDatastoreRepresentation();
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] pos, Object container) {
        Object value = null;
        if (container != null) {
            ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(this.mmd.getType());
            ContainerAdapter containerAdapter = containerHandler.getAdapter(container);
            Iterator iterator = containerAdapter.iterator();
            value = iterator.hasNext() ? iterator.next() : null;
        }
        this.wrappedMapping.setObject(ec, ps, pos, value);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex) {
        Object object = this.wrappedMapping.getObject(ec, rs, exprIndex);
        ElementContainerHandler containerHandler = (ElementContainerHandler)ec.getTypeManager().getContainerHandler(this.mmd.getType());
        return containerHandler.newContainer(this.mmd, new Object[]{object});
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] exprIndex, DNStateManager ownerSM, int ownerFieldNumber) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public int getNumberOfColumnMappings() {
        return this.wrappedMapping.getNumberOfColumnMappings();
    }

    @Override
    public ColumnMapping[] getColumnMappings() {
        return this.wrappedMapping.getColumnMappings();
    }

    @Override
    public ColumnMapping getColumnMapping(int index) {
        return this.wrappedMapping.getColumnMapping(index);
    }

    @Override
    public String getJavaTypeForColumnMapping(int index) {
        return this.wrappedMapping.getJavaTypeForColumnMapping(index);
    }

    @Override
    public void postInsert(DNStateManager sm) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postInsert(sm);
        }
    }

    @Override
    public void postFetch(DNStateManager sm) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postFetch(sm);
        }
    }

    @Override
    public void postUpdate(DNStateManager sm) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).postUpdate(sm);
        }
    }

    @Override
    public void preDelete(DNStateManager sm) {
        if (this.wrappedMapping instanceof MappingCallbacks) {
            ((MappingCallbacks)((Object)this.wrappedMapping)).preDelete(sm);
        }
    }

    @Override
    public Class getJavaType() {
        return this.wrappedMapping.getJavaType();
    }

    private class WrappedMemberMetaData
    extends AbstractMemberMetaData {
        private static final long serialVersionUID = 8346519560709746659L;
        private AbstractMemberMetaData singleCollectionMetadata;

        public WrappedMemberMetaData(AbstractMemberMetaData fmd, Class type, ClassLoaderResolver clr) {
            super(fmd.getParent(), fmd);
            this.singleCollectionMetadata = fmd;
            this.type = type;
            this.columnMetaData = fmd.getElementMetaData() != null ? fmd.getElementMetaData().getColumnMetaData() : fmd.getColumnMetaData();
            this.relationType = fmd.getRelationType(clr);
            this.relatedMemberMetaData = fmd.getRelatedMemberMetaData(clr);
            ElementMetaData fmdElementMetaData = fmd.getElementMetaData();
            if (fmdElementMetaData != null && fmdElementMetaData.getEmbeddedMetaData() != null) {
                this.setEmbeddedMetaData(fmdElementMetaData.getEmbeddedMetaData());
            }
        }

        public int getAbsoluteFieldNumber() {
            return this.singleCollectionMetadata.getAbsoluteFieldNumber();
        }

        public boolean isDependent() {
            return super.isDependent() || this.getCollection().isDependentElement();
        }

        public String toString() {
            return "Wrapped[" + this.getName() + "]\n" + super.toString();
        }
    }
}

