/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.MappingType;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.MapExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.Localiser;

public class MapKeyMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(Localiser.msg((String)"060016", (Object[])new Object[]{"mapKey", "MapExpression", 0}));
        }
        MapExpression mapExpr = (MapExpression)expr;
        return this.getAsJoin(stmt, mapExpr);
    }

    protected SQLExpression getAsJoin(SQLStatement parentStmt, MapExpression mapExpr) {
        JavaTypeMapping m = mapExpr.getJavaTypeMapping();
        RDBMSStoreManager storeMgr = parentStmt.getRDBMSManager();
        ClassLoaderResolver clr = parentStmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpressionFactory exprFactory = parentStmt.getSQLExpressionFactory();
        AbstractMemberMetaData mmd = m.getMemberMetaData();
        SQLStatement stmt = mapExpr.getSQLTable().getSQLStatement();
        if (mmd != null) {
            MapMetaData mapmd = mmd.getMap();
            SQLTable mapSqlTbl = mapExpr.getSQLTable();
            String mapJoinAlias = mapExpr.getAliasForMapTable();
            if (mapJoinAlias == null) {
                mapJoinAlias = (mapExpr.getSQLTable().getAlias().toString() + "_" + mmd.getName()).toUpperCase();
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
                MapTable joinTbl = (MapTable)storeMgr.getTable(mmd);
                SQLTable joinSqlTbl = stmt.getTable(mapJoinAlias);
                if (joinSqlTbl == null) {
                    joinSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapSqlTbl, mapSqlTbl.getTable().getIdMapping(), joinTbl, mapJoinAlias, joinTbl.getOwnerMapping(), null, null);
                }
                if (mapmd.getKeyClassMetaData(clr) != null && !mapmd.isEmbeddedKey()) {
                    DatastoreClass keyTable = storeMgr.getDatastoreClass(mapmd.getKeyType(), clr);
                    SQLTable keySqlTbl = stmt.getTable(mapJoinAlias + "_KEY");
                    if (keySqlTbl == null) {
                        keySqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, joinSqlTbl, joinTbl.getKeyMapping(), keyTable, mapJoinAlias + "_KEY", keyTable.getIdMapping(), null, null);
                    }
                    return exprFactory.newExpression(stmt, keySqlTbl, keyTable.getIdMapping());
                }
                return exprFactory.newExpression(stmt, joinSqlTbl, joinTbl.getKeyMapping());
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                DatastoreClass valTable = storeMgr.getDatastoreClass(mapmd.getValueType(), clr);
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
                JavaTypeMapping mapTblOwnerMapping = mmd.getMappedBy() != null ? valTable.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : valTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                SQLTable valSqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapSqlTbl, mapSqlTbl.getTable().getIdMapping(), valTable, mapJoinAlias, mapTblOwnerMapping, null, null);
                AbstractMemberMetaData valKeyMmd = mapmd.getValueClassMetaData(clr).getMetaDataForMember(mmd.getKeyMetaData().getMappedBy());
                JavaTypeMapping keyMapping = valTable.getMemberMapping(valKeyMmd);
                return exprFactory.newExpression(stmt, valSqlTbl, keyMapping);
            }
            if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
                DatastoreClass keyTable = storeMgr.getDatastoreClass(mapmd.getKeyType(), clr);
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
                JavaTypeMapping mapTblOwnerMapping = mmd.getMappedBy() != null ? keyTable.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : keyTable.getExternalMapping(mmd, MappingType.EXTERNAL_FK);
                SQLTable keySqlTbl = stmt.join(SQLJoin.JoinType.INNER_JOIN, mapSqlTbl, mapSqlTbl.getTable().getIdMapping(), keyTable, mapJoinAlias, mapTblOwnerMapping, null, null);
                return exprFactory.newExpression(stmt, keySqlTbl, keyTable.getIdMapping());
            }
        }
        throw new NucleusException("KEY(map) for the filter is not supported for " + mapExpr + ". Why not contribute support for it?");
    }

    protected SQLExpression getAsSubquery(SQLStatement stmt, MapExpression mapExpr) {
        AbstractMemberMetaData mmd = mapExpr.getJavaTypeMapping().getMemberMetaData();
        MapMetaData mapmd = mmd.getMap();
        RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        JavaTypeMapping ownerMapping = null;
        JavaTypeMapping keyMapping = null;
        Table mapTbl = null;
        if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_JOIN) {
            mapTbl = storeMgr.getTable(mmd);
            ownerMapping = ((MapTable)mapTbl).getOwnerMapping();
            keyMapping = ((MapTable)mapTbl).getKeyMapping();
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            AbstractClassMetaData valCmd = mapmd.getValueClassMetaData(clr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getValueType(), clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(valCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            String keyFieldName = mmd.getKeyMetaData().getMappedBy();
            AbstractMemberMetaData valKeyMmd = valCmd.getMetaDataForMember(keyFieldName);
            keyMapping = mapTbl.getMemberMapping(valKeyMmd);
        } else if (mapmd.getMapType() == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            AbstractClassMetaData keyCmd = mapmd.getKeyClassMetaData(clr);
            mapTbl = storeMgr.getDatastoreClass(mmd.getMap().getKeyType(), clr);
            ownerMapping = mmd.getMappedBy() != null ? mapTbl.getMemberMapping(keyCmd.getMetaDataForMember(mmd.getMappedBy())) : ((DatastoreClass)mapTbl).getExternalMapping(mmd, MappingType.EXTERNAL_FK);
            keyMapping = mapTbl.getIdMapping();
        } else {
            throw new NucleusException("Invalid map for " + mapExpr + " in get() call");
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        SelectStatement subStmt = new SelectStatement(stmt, storeMgr, mapTbl, null, null);
        subStmt.setClassLoaderResolver(clr);
        SQLExpression keyExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), keyMapping);
        subStmt.select(keyExpr, null);
        SQLExpression elementOwnerExpr = exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
        SQLExpression ownerIdExpr = exprFactory.newExpression(stmt, mapExpr.getSQLTable(), mapExpr.getSQLTable().getTable().getIdMapping());
        subStmt.whereAnd(elementOwnerExpr.eq(ownerIdExpr), true);
        SubqueryExpression subExpr = new SubqueryExpression(stmt, subStmt);
        subExpr.setJavaTypeMapping(keyMapping);
        return subExpr;
    }
}

