/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.StringMatchesMethod;

public class StringSimilarPostgresqlMethod
extends StringMatchesMethod {
    public static final Expression.DyadicOperator OP_SIMILAR_TO = new Expression.DyadicOperator("SIMILAR TO", 3, false);

    @Override
    protected BooleanExpression getExpressionForStringExpressionInput(SQLStatement stmt, SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        return this.getBooleanLikeExpression(stmt, expr, regExpr, escapeExpr);
    }

    @Override
    protected BooleanExpression getBooleanLikeExpression(SQLStatement stmt, SQLExpression expr, SQLExpression regExpr, SQLExpression escapeExpr) {
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        BooleanExpression similarToExpr = new BooleanExpression(stmt, exprFactory.getMappingForType(Boolean.TYPE, false));
        SQLText sql = similarToExpr.toSQLText();
        sql.clearStatement();
        if (OP_SIMILAR_TO.isHigherThanLeftSide(expr.getLowestOperator())) {
            sql.append("(").append(expr).append(")");
        } else {
            sql.append(expr);
        }
        sql.append(" SIMILAR TO ");
        if (OP_SIMILAR_TO.isHigherThanRightSide(regExpr.getLowestOperator())) {
            sql.append("(").append(regExpr).append(")");
        } else {
            sql.append(regExpr);
        }
        BaseDatastoreAdapter dba = (BaseDatastoreAdapter)stmt.getRDBMSManager().getDatastoreAdapter();
        if (escapeExpr != null) {
            if (escapeExpr instanceof CharacterLiteral) {
                String chr = "" + ((CharacterLiteral)escapeExpr).getValue();
                if (chr.equals(dba.getEscapeCharacter())) {
                    sql.append(dba.getEscapePatternExpression());
                } else {
                    sql.append(" ESCAPE " + escapeExpr);
                }
            } else {
                sql.append(" ESCAPE " + escapeExpr);
            }
        } else {
            sql.append(" " + dba.getEscapePatternExpression());
        }
        return similarToExpr;
    }
}

