/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class StringStartsWith3Method
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args == null || args.size() == 0 || args.size() > 2) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"startsWith", "StringExpression", 0, "StringExpression/CharacterExpression/Parameter"}));
        }
        SQLExpression substrExpr = args.get(0);
        if (!(substrExpr instanceof StringExpression || substrExpr instanceof CharacterExpression || substrExpr instanceof ParameterLiteral)) {
            throw new NucleusException(Localiser.msg((String)"060003", (Object[])new Object[]{"startsWith", "StringExpression", 0, "StringExpression/CharacterExpression/Parameter"}));
        }
        SQLExpression one = ExpressionUtils.getLiteralForOne(stmt);
        if (args.size() > 1) {
            SQLExpression numExpr = args.get(1);
            List<SQLExpression> funcArgs = List.of(substrExpr, expr);
            return new BooleanExpression(new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE), "LOCATE", funcArgs), Expression.OP_EQ, one.add(numExpr));
        }
        List<SQLExpression> funcArgs = List.of(substrExpr, expr);
        return new BooleanExpression(new StringExpression(stmt, stmt.getSQLExpressionFactory().getMappingForType(Integer.TYPE), "LOCATE", funcArgs), Expression.OP_EQ, one);
    }
}

