/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.NucleusLogger;

public class MaxGenerator
extends AbstractConnectedGenerator<Long> {
    public MaxGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
        this.allocationSize = 1;
    }

    /*
     * Loose catch block
     */
    public ValueGenerationBlock reserveBlock(long size) {
        try {
            ValueGenerationBlock valueGenerationBlock;
            ManagedConnection mconn = this.connectionProvider.retrieveConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            SQLController sqlControl = ((RDBMSStoreManager)this.storeMgr).getSQLController();
            try {
                String stmt = this.getStatement();
                ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                rs = sqlControl.executeStatementQuery(null, mconn, stmt, ps);
                if (!rs.next()) {
                    ValueGenerationBlock valueGenerationBlock2 = new ValueGenerationBlock(new Object[]{1L});
                    return valueGenerationBlock2;
                }
                valueGenerationBlock = new ValueGenerationBlock(new Object[]{rs.getLong(1) + 1L});
            }
            catch (SQLException e) {
                NucleusLogger.VALUEGENERATION.warn((Object)"Exception thrown getting next value for MaxGenerator", (Throwable)e);
                throw new ValueGenerationException("Exception thrown getting next value for MaxGenerator", (Throwable)e);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                catch (SQLException sQLException) {}
            }
            return valueGenerationBlock;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
    }

    private String getStatement() {
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        StringBuilder stmt = new StringBuilder();
        stmt.append("SELECT max(");
        stmt.append(srm.getIdentifierFactory().getIdentifierInAdapterCase((String)this.properties.get("column-name")));
        stmt.append(") FROM ");
        stmt.append(srm.getIdentifierFactory().getIdentifierInAdapterCase((String)this.properties.get("table-name")));
        return stmt.toString();
    }

    public AbstractConnectedGenerator.ConnectionPreference getConnectionPreference() {
        return AbstractConnectedGenerator.ConnectionPreference.EXISTING;
    }
}

