/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.valuegenerator;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSPropertyNames;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.DatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.valuegenerator.SequenceTable;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public final class TableGenerator
extends AbstractConnectedGenerator<Long> {
    protected ManagedConnection connection;
    protected boolean repositoryExists = false;
    private SequenceTable sequenceTable = null;
    private final String sequenceName;
    public static final String DEFAULT_TABLE_NAME = "SEQUENCE_TABLE";
    public static final String DEFAULT_SEQUENCE_COLUMN_NAME = "SEQUENCE_NAME";
    public static final String DEFAULT_NEXTVALUE_COLUMN_NAME = "NEXT_VAL";

    public TableGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
        this.allocationSize = 5;
        this.initialValue = -1;
        if (this.properties != null) {
            if (this.properties.containsKey("key-cache-size")) {
                try {
                    this.allocationSize = Integer.parseInt(this.properties.getProperty("key-cache-size"));
                }
                catch (Exception e) {
                    throw new ValueGenerationException(Localiser.msg((String)"Sequence040006", (Object[])new Object[]{this.properties.get("key-cache-size")}));
                }
            }
            if (this.properties.containsKey("key-initial-value")) {
                try {
                    this.initialValue = Integer.parseInt(this.properties.getProperty("key-initial-value"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.sequenceName = this.properties.containsKey("sequence-name") ? this.properties.getProperty("sequence-name") : (this.properties.containsKey("sequence-table-basis") && this.properties.getProperty("sequence-table-basis").equalsIgnoreCase("table") ? this.properties.getProperty("table-name") : this.properties.getProperty("root-class-name"));
        } else {
            this.sequenceName = "SEQUENCENAME";
        }
    }

    public static Class getStorageClass() {
        return Long.class;
    }

    public SequenceTable getTable() {
        return this.sequenceTable;
    }

    public ValueGenerationBlock<Long> reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<Long> oid = new ArrayList<Long>();
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            DatastoreIdentifier sourceTableIdentifier = null;
            if (this.properties.containsKey("table-name")) {
                sourceTableIdentifier = ((RDBMSStoreManager)this.storeMgr).getIdentifierFactory().newTableIdentifier(this.properties.getProperty("table-name"));
            }
            Long nextId = this.sequenceTable.getNextVal(this.sequenceName, this.connection, (int)size, sourceTableIdentifier, this.properties.getProperty("column-name"), this.initialValue);
            int i = 0;
            while ((long)i < size) {
                oid.add(nextId);
                nextId = nextId + 1L;
                ++i;
            }
            if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                NucleusLogger.VALUEGENERATION.debug((Object)Localiser.msg((String)"040004", (Object[])new Object[]{"" + size}));
            }
            return new ValueGenerationBlock(oid);
        }
        catch (SQLException e) {
            throw new ValueGenerationException(Localiser.msg((String)"061001", (Object[])new Object[]{e.getMessage()}));
        }
    }

    protected boolean repositoryExists() {
        if (this.repositoryExists) {
            return true;
        }
        if (this.storeMgr.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_OMIT_DATABASEMETADATA_GETCOLUMNS) || this.storeMgr.getBooleanProperty(RDBMSPropertyNames.PROPERTY_RDBMS_OMIT_VALUE_GENERATION_GETCOLUMNS)) {
            NucleusLogger.VALUEGENERATION.debug((Object)"Omitting information schema call during the creation of value generation");
            this.repositoryExists = true;
            return true;
        }
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists((Connection)this.connection.getConnection(), true);
            this.repositoryExists = true;
            return true;
        }
        catch (SQLException sqle) {
            throw new ValueGenerationException("Exception thrown calling table.exists() for " + this.sequenceTable, (Throwable)sqle);
        }
    }

    protected boolean createRepository() {
        RDBMSStoreManager srm = (RDBMSStoreManager)this.storeMgr;
        if (!srm.getSchemaHandler().isAutoCreateTables()) {
            throw new NucleusUserException(Localiser.msg((String)"040011", (Object[])new Object[]{this.sequenceTable}));
        }
        try {
            if (this.sequenceTable == null) {
                this.initialiseSequenceTable();
            }
            this.sequenceTable.exists((Connection)this.connection.getConnection(), true);
            this.repositoryExists = true;
            return true;
        }
        catch (SQLException sqle) {
            throw new ValueGenerationException("Exception thrown calling table.exists() for " + this.sequenceTable, (Throwable)sqle);
        }
    }

    protected synchronized void initialiseSequenceTable() {
        DatastoreClass table;
        String schemaName;
        String catalogName = this.properties.getProperty("sequence-catalog-name");
        if (catalogName == null) {
            catalogName = this.properties.getProperty("catalog-name");
        }
        if ((schemaName = this.properties.getProperty("sequence-schema-name")) == null) {
            schemaName = this.properties.getProperty("schema-name");
        }
        String tableName = this.properties.getProperty("sequence-table-name") == null ? DEFAULT_TABLE_NAME : this.properties.getProperty("sequence-table-name");
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        DatastoreAdapter dba = storeMgr.getDatastoreAdapter();
        DatastoreIdentifier identifier = storeMgr.getIdentifierFactory().newTableIdentifier(tableName);
        if (dba.supportsOption("CatalogInTableDefinition") && catalogName != null) {
            identifier.setCatalogName(catalogName);
        }
        if (dba.supportsOption("SchemaInTableDefinition") && schemaName != null) {
            identifier.setSchemaName(schemaName);
        }
        if ((table = storeMgr.getDatastoreClass(identifier)) != null) {
            this.sequenceTable = (SequenceTable)((Object)table);
        } else {
            String sequenceNameColumnName = DEFAULT_SEQUENCE_COLUMN_NAME;
            if (this.properties.containsKey("sequence-name-column-name")) {
                sequenceNameColumnName = this.properties.getProperty("sequence-name-column-name");
            }
            String nextValColumnName = DEFAULT_NEXTVALUE_COLUMN_NAME;
            if (this.properties.containsKey("sequence-nextval-column-name")) {
                nextValColumnName = this.properties.getProperty("sequence-nextval-column-name");
            }
            this.sequenceTable = new SequenceTable(identifier, storeMgr, sequenceNameColumnName, nextValColumnName);
            this.sequenceTable.initialize(storeMgr.getNucleusContext().getClassLoaderResolver(null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock<Long> obtainGenerationBlock(int number) {
        ValueGenerationBlock<Long> block = null;
        boolean repository_exists = true;
        try {
            this.connection = this.connectionProvider.retrieveConnection();
            if (!this.repositoryExists) {
                TableGenerator tableGenerator = this;
                synchronized (tableGenerator) {
                    this.repositoryExists = this.repositoryExists();
                    if (!this.repositoryExists) {
                        this.createRepository();
                        this.repositoryExists = true;
                    }
                }
            }
            try {
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            catch (ValueGenerationException vge) {
                NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040003", (Object[])new Object[]{vge.getMessage()}));
                if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                    NucleusLogger.VALUEGENERATION.debug((Object)"Caught exception", (Throwable)vge);
                }
                repository_exists = false;
            }
            catch (RuntimeException ex) {
                NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040003", (Object[])new Object[]{ex.getMessage()}));
                if (NucleusLogger.VALUEGENERATION.isDebugEnabled()) {
                    NucleusLogger.VALUEGENERATION.debug((Object)"Caught exception", (Throwable)ex);
                }
                repository_exists = false;
            }
        }
        finally {
            if (this.connection != null) {
                this.connectionProvider.releaseConnection();
                this.connection = null;
            }
        }
        if (!repository_exists) {
            try {
                this.connection = this.connectionProvider.retrieveConnection();
                NucleusLogger.VALUEGENERATION.info((Object)Localiser.msg((String)"040005"));
                if (!this.createRepository()) {
                    throw new ValueGenerationException(Localiser.msg((String)"040002"));
                }
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            finally {
                this.connectionProvider.releaseConnection();
                this.connection = null;
            }
        }
        return block;
    }
}

