/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.IOException;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.hcatalog.templeton.tool.HDFSStorage;
import org.apache.hive.hcatalog.templeton.tool.TempletonStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSCleanup
extends Thread {
    protected Configuration appConf;
    public static final String HDFS_CLEANUP_INTERVAL = "templeton.hdfs.cleanup.interval";
    public static final String HDFS_CLEANUP_MAX_AGE = "templeton.hdfs.cleanup.maxage";
    protected static long interval = 43200000L;
    protected static long maxage = 604800000L;
    private static final Logger LOG = LoggerFactory.getLogger(HDFSCleanup.class);
    private boolean stop = false;
    private static HDFSCleanup thisclass = null;
    private static boolean isRunning = false;
    private String storage_root;

    private HDFSCleanup(Configuration appConf) {
        this.appConf = appConf;
        interval = appConf.getLong(HDFS_CLEANUP_INTERVAL, interval);
        maxage = appConf.getLong(HDFS_CLEANUP_MAX_AGE, maxage);
        this.storage_root = appConf.get("templeton.storage.root");
    }

    public static HDFSCleanup getInstance(Configuration appConf) {
        if (thisclass != null) {
            return thisclass;
        }
        thisclass = new HDFSCleanup(appConf);
        return thisclass;
    }

    public static void startInstance(Configuration appConf) throws IOException {
        if (!isRunning) {
            HDFSCleanup.getInstance(appConf).start();
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                FileSystem fs = null;
                try {
                    fs = new Path(this.storage_root).getFileSystem(this.appConf);
                    this.checkFiles(fs);
                }
                catch (Exception e) {
                    LOG.error("Cleanup cycle failed: " + e.getMessage());
                }
                finally {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Exception e) {
                            LOG.error("Closing file system failed: " + e.getMessage());
                        }
                    }
                }
                long sleepMillis = (long)(Math.random() * (double)interval);
                LOG.info("Next execution: " + String.valueOf(new Date(new Date().getTime() + sleepMillis)));
                Thread.sleep(sleepMillis);
            }
            catch (Exception e) {
                isRunning = false;
                LOG.error("Cleanup failed: " + e.getMessage(), (Throwable)e);
            }
        }
        isRunning = false;
    }

    private void checkFiles(FileSystem fs) throws IOException {
        long now = new Date().getTime();
        for (TempletonStorage.Type type : TempletonStorage.Type.values()) {
            try {
                for (FileStatus status : fs.listStatus(new Path(HDFSStorage.getPath(type, this.storage_root)))) {
                    if (now - status.getModificationTime() <= maxage) continue;
                    LOG.info("Deleting " + status.getPath().toString());
                    fs.delete(status.getPath(), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exit() {
        this.stop = true;
    }
}

