/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Counter;
import java.sql.Connection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSMetricsListener
extends MetaStoreEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMSMetricsListener.class);
    private Counter createdDatabases = Metrics.getOrCreateCounter("create_total_count_dbs");
    private Counter deletedDatabases = Metrics.getOrCreateCounter("delete_total_count_dbs");
    private Counter createdTables = Metrics.getOrCreateCounter("create_total_count_tables");
    private Counter deletedTables = Metrics.getOrCreateCounter("delete_total_count_tables");
    private Counter createdParts = Metrics.getOrCreateCounter("create_total_count_partitions");
    private Counter deletedParts = Metrics.getOrCreateCounter("delete_total_count_partitions");

    public HMSMetricsListener(Configuration config) {
        super(config);
    }

    @Override
    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_dbs").incrementAndGet();
        this.createdDatabases.inc();
    }

    @Override
    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_dbs").decrementAndGet();
        this.deletedDatabases.inc();
    }

    @Override
    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_tables").incrementAndGet();
        this.createdTables.inc();
    }

    @Override
    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_tables").decrementAndGet();
        this.deletedTables.inc();
    }

    @Override
    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_partitions").decrementAndGet();
        this.deletedParts.inc();
    }

    @Override
    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Metrics.getOrCreateGauge("total_count_partitions").incrementAndGet();
        this.createdParts.inc();
    }

    @Override
    public void onAllocWriteId(AllocWriteIdEvent allocWriteIdEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        int numOfWritesToDisabledCompactionTable;
        if (MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON) && this.isNoAutoCompactSet(allocWriteIdEvent).booleanValue() && (numOfWritesToDisabledCompactionTable = Metrics.getOrCreateGauge("num_writes_to_disabled_compaction_table").incrementAndGet()) >= MetastoreConf.getIntVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_NUMBER_OF_DISABLED_COMPACTION_TABLES_THRESHOLD)) {
            LOGGER.warn("There has been a write to table " + allocWriteIdEvent.getDbName() + "." + allocWriteIdEvent.getTableName() + " where auto-compaction is disabled \"no_auto_compact\"=\"true\".");
        }
    }

    private Boolean isNoAutoCompactSet(AllocWriteIdEvent allocWriteIdEvent) throws MetaException {
        Map dbParameters;
        String catalog = MetaStoreUtils.getDefaultCatalog((Configuration)this.getConf());
        String dbName = allocWriteIdEvent.getDbName();
        String tableName = allocWriteIdEvent.getTableName();
        RawStore rawStore = allocWriteIdEvent.getIHMSHandler() != null ? allocWriteIdEvent.getIHMSHandler().getMS() : HMSHandler.getMSForConf(this.getConf());
        try {
            dbParameters = rawStore.getDatabase(catalog, dbName).getParameters();
        }
        catch (NoSuchObjectException e) {
            LOGGER.error("Unable to find database " + dbName + ", " + e.getMessage());
            throw new MetaException(String.valueOf((Object)e));
        }
        Table table = rawStore.getTable(catalog, dbName, tableName);
        if (table != null) {
            return MetaStoreUtils.isNoAutoCompactSet((Map)dbParameters, (Map)table.getParameters());
        }
        return false;
    }
}

