/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.commons.cli.OptionBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.CommonCliOptions;

class HiveMetastoreCli
extends CommonCliOptions {
    private int port;

    HiveMetastoreCli(Configuration configuration) {
        super("hivemetastore", true);
        this.port = MetastoreConf.getIntVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERVER_PORT);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.withDescription((String)("Hive Metastore port number, default:" + this.port));
        this.OPTIONS.addOption(OptionBuilder.create((char)'p'));
    }

    @Override
    public void parse(String[] args) {
        super.parse(args);
        args = this.commandLine.getArgs();
        if (args.length > 0) {
            System.err.println("This usage has been deprecated, consider using the new command line syntax (run with -h to see usage information)");
            this.port = Integer.parseInt(args[0]);
        }
        if (this.commandLine.hasOption('p')) {
            this.port = Integer.parseInt(this.commandLine.getOptionValue('p'));
        } else {
            String metastorePort = System.getenv("METASTORE_PORT");
            if (metastorePort != null) {
                this.port = Integer.parseInt(metastorePort);
            }
        }
    }

    public int getPort() {
        return this.port;
    }
}

