/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.oauth2;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import java.util.List;
import org.apache.hadoop.hive.metastore.auth.HttpAuthenticationException;

public interface OAuth2Authenticator {
    public String resolveUserName(String var1, List<String> var2) throws HttpAuthenticationException;

    public static void requireBearerToken(String bearerToken) throws HttpAuthenticationException {
        if (bearerToken == null) {
            BearerTokenError error = BearerTokenError.MISSING_TOKEN;
            throw new HttpAuthenticationException("Missing bearer token", error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
    }

    public static void requireScopes(Scope tokenScope, List<String> requiredScopes) throws HttpAuthenticationException {
        if (tokenScope == null) {
            BearerTokenError error = BearerTokenError.INSUFFICIENT_SCOPE.setScope(Scope.parse(requiredScopes));
            throw new HttpAuthenticationException("This resource requires the following scopes: " + String.valueOf(requiredScopes), error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        List<String> insufficient = requiredScopes.stream().filter(requiredScope -> !tokenScope.contains(requiredScope)).toList();
        if (!insufficient.isEmpty()) {
            BearerTokenError error = BearerTokenError.INSUFFICIENT_SCOPE.setScope(Scope.parse(requiredScopes));
            throw new HttpAuthenticationException("Insufficient scopes: " + String.valueOf(insufficient), error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
    }
}

