/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageBuilder;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TException;

public class JSONDropDatabaseMessage
extends DropDatabaseMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String dbJson;
    @JsonProperty
    Long timestamp;

    public JSONDropDatabaseMessage() {
    }

    public JSONDropDatabaseMessage(String server, String servicePrincipal, Database db, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db.getName();
        this.timestamp = timestamp;
        try {
            this.dbJson = MessageBuilder.createDatabaseObjJson(db);
        }
        catch (TException ex) {
            throw new IllegalArgumentException("Could not serialize database object", ex);
        }
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Database getDatabaseObject() throws Exception {
        return (Database)MessageBuilder.getTObj(this.dbJson, Database.class);
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

