/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.MetaWrapperException;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class InsertCompactionInfoCommand
implements ParameterizedCommand {
    private final CompactionInfo ci;
    private final long compactionEndTime;
    private static final String INSERT = "INSERT INTO \"COMPLETED_COMPACTIONS\"    (\"CC_ID\", \"CC_DATABASE\", \"CC_TABLE\", \"CC_PARTITION\", \"CC_STATE\", \"CC_TYPE\",    \"CC_TBLPROPERTIES\", \"CC_WORKER_ID\", \"CC_START\", \"CC_END\", \"CC_RUN_AS\",    \"CC_HIGHEST_WRITE_ID\", \"CC_META_INFO\", \"CC_HADOOP_JOB_ID\", \"CC_ERROR_MESSAGE\",    \"CC_ENQUEUE_TIME\", \"CC_WORKER_VERSION\", \"CC_INITIATOR_ID\", \"CC_INITIATOR_VERSION\",   \"CC_NEXT_TXN_ID\", \"CC_TXN_ID\", \"CC_COMMIT_TIME\", \"CC_POOL_NAME\", \"CC_NUMBER_OF_BUCKETS\",    \"CC_ORDER_BY\")    VALUES(:id,:dbname,:tableName,:partName,:state,:type,:properties,:workerId,:start,:endTime,    :runAs,:highestWriteId,:metaInfo,:hadoopJobId,:errorMessage,:enqueueTime,:workerVersion,:initiatorId,    :initiatorVersion,:nextTxnId,:txnId,:commitTime,:poolName,:numberOfBuckets,:orderByClause)";

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return ParameterizedCommand.EXACTLY_ONE_ROW;
    }

    public InsertCompactionInfoCommand(CompactionInfo ci, long compactionEndTime) {
        this.ci = ci;
        this.compactionEndTime = compactionEndTime;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return INSERT;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        try {
            return new MapSqlParameterSource().addValue("id", (Object)this.ci.id).addValue("dbname", (Object)this.ci.dbname).addValue("tableName", (Object)this.ci.tableName).addValue("partName", (Object)this.ci.partName).addValue("state", (Object)Character.toString(this.ci.state)).addValue("type", (Object)Character.toString(TxnUtils.thriftCompactionType2DbType(this.ci.type).charValue())).addValue("properties", (Object)this.ci.properties).addValue("workerId", (Object)this.ci.workerId).addValue("start", (Object)this.ci.start).addValue("endTime", (Object)this.compactionEndTime).addValue("runAs", (Object)this.ci.runAs).addValue("highestWriteId", (Object)this.ci.highestWriteId).addValue("metaInfo", (Object)this.ci.metaInfo).addValue("hadoopJobId", (Object)this.ci.hadoopJobId).addValue("errorMessage", (Object)this.ci.errorMessage).addValue("enqueueTime", (Object)this.ci.enqueueTime).addValue("workerVersion", (Object)this.ci.workerVersion).addValue("initiatorId", (Object)this.ci.initiatorId).addValue("initiatorVersion", (Object)this.ci.initiatorVersion).addValue("nextTxnId", (Object)this.ci.nextTxnId).addValue("txnId", (Object)this.ci.txnId).addValue("commitTime", (Object)this.ci.commitTime).addValue("poolName", (Object)this.ci.poolName).addValue("numberOfBuckets", (Object)this.ci.numberOfBuckets).addValue("orderByClause", (Object)this.ci.orderByClause);
        }
        catch (MetaException e) {
            throw new MetaWrapperException(e);
        }
    }
}

