/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetValidWriteIdsForTableFunction
implements TransactionalFunction<TableValidWriteIds> {
    private final ValidTxnList validTxnList;
    private final String fullTableName;

    public GetValidWriteIdsForTableFunction(ValidTxnList validTxnList, String fullTableName) {
        this.validTxnList = validTxnList;
        this.fullTableName = fullTableName;
    }

    @Override
    public TableValidWriteIds execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        String[] names = TxnUtils.getDbTableName(this.fullTableName);
        assert (names.length == 2);
        long writeIdHwm = Objects.requireNonNull((Long)jdbcResource.getJdbcTemplate().query("SELECT MAX(\"T2W_WRITEID\") FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" <= :txnHwm  AND \"T2W_DATABASE\" = :db AND \"T2W_TABLE\" = :table", (SqlParameterSource)new MapSqlParameterSource().addValue("txnHwm", (Object)this.validTxnList.getHighWatermark()).addValue("db", (Object)names[0]).addValue("table", (Object)names[1]), (ResultSetExtractor)new HwmExtractor()));
        if (writeIdHwm <= 0L) {
            writeIdHwm = Objects.requireNonNull((Long)jdbcResource.getJdbcTemplate().query("SELECT \"NWI_NEXT\" -1 FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = :db AND \"NWI_TABLE\" = :table", (SqlParameterSource)new MapSqlParameterSource().addValue("db", (Object)names[0]).addValue("table", (Object)names[1]), (ResultSetExtractor)new HwmExtractor()));
        }
        ArrayList<Long> invalidWriteIdList = new ArrayList<Long>();
        BitSet abortedBits = new BitSet();
        AtomicLong minOpenWriteId = new AtomicLong(Long.MAX_VALUE);
        AtomicBoolean foundValidUncompactedWrite = new AtomicBoolean(false);
        jdbcResource.getJdbcTemplate().query("SELECT \"T2W_TXNID\", \"T2W_WRITEID\" FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_WRITEID\" <= :writeIdHwm AND \"T2W_DATABASE\" = :db AND \"T2W_TABLE\" = :table ORDER BY \"T2W_WRITEID\" ASC", (SqlParameterSource)new MapSqlParameterSource().addValue("writeIdHwm", (Object)writeIdHwm).addValue("db", (Object)names[0]).addValue("table", (Object)names[1]), rs -> {
            while (rs.next()) {
                long txnId = rs.getLong(1);
                long writeId = rs.getLong(2);
                if (this.validTxnList.isTxnValid(txnId)) {
                    foundValidUncompactedWrite.set(true);
                    continue;
                }
                invalidWriteIdList.add(writeId);
                if (this.validTxnList.isTxnAborted(txnId)) {
                    abortedBits.set(invalidWriteIdList.size() - 1);
                    continue;
                }
                minOpenWriteId.set(Math.min(minOpenWriteId.get(), writeId));
            }
            return null;
        });
        if (!foundValidUncompactedWrite.get()) {
            long writeId = invalidWriteIdList.isEmpty() ? -1L : (Long)invalidWriteIdList.get(0);
            invalidWriteIdList.clear();
            abortedBits.clear();
            if (writeId != -1L) {
                invalidWriteIdList.add(writeId);
                writeIdHwm = writeId;
                if (writeId != minOpenWriteId.get()) {
                    abortedBits.set(0);
                }
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(abortedBits.toByteArray());
        TableValidWriteIds owi = new TableValidWriteIds(this.fullTableName, writeIdHwm, invalidWriteIdList, byteBuffer);
        if (minOpenWriteId.get() < Long.MAX_VALUE) {
            owi.setMinOpenWriteId(minOpenWriteId.get());
        }
        return owi;
    }

    private static class HwmExtractor
    implements ResultSetExtractor<Long> {
        private HwmExtractor() {
        }

        public Long extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        }
    }
}

