/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class TopCompactionMetricsDataPerTypeFunction
implements TransactionalFunction<List<CompactionMetricsData>> {
    private static final String NO_SELECT_COMPACTION_METRICS_CACHE_FOR_TYPE_QUERY = "\"CMC_DATABASE\", \"CMC_TABLE\", \"CMC_PARTITION\", \"CMC_METRIC_VALUE\", \"CMC_VERSION\" FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_METRIC_TYPE\" = :type ORDER BY \"CMC_METRIC_VALUE\" DESC";
    private final int limit;

    public TopCompactionMetricsDataPerTypeFunction(int limit) {
        this.limit = limit;
    }

    @Override
    public List<CompactionMetricsData> execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        ArrayList<CompactionMetricsData> metricsDataList = new ArrayList<CompactionMetricsData>();
        for (CompactionMetricsData.MetricType type : CompactionMetricsData.MetricType.values()) {
            metricsDataList.addAll(jdbcResource.getJdbcTemplate().query(jdbcResource.getSqlGenerator().addLimitClause(this.limit, NO_SELECT_COMPACTION_METRICS_CACHE_FOR_TYPE_QUERY), (SqlParameterSource)new MapSqlParameterSource().addValue("type", (Object)type.toString()), (RowMapper)new CompactionMetricsDataMapper(type)));
        }
        return metricsDataList;
    }

    private static class CompactionMetricsDataMapper
    implements RowMapper<CompactionMetricsData> {
        private final CompactionMetricsData.MetricType type;
        private final CompactionMetricsData.Builder builder = new CompactionMetricsData.Builder();

        public CompactionMetricsDataMapper(CompactionMetricsData.MetricType type) {
            this.type = type;
        }

        public CompactionMetricsData mapRow(ResultSet rs, int rowNum) throws SQLException {
            return this.builder.dbName(rs.getString(1)).tblName(rs.getString(2)).partitionName(rs.getString(3)).metricType(this.type).metricValue(rs.getInt(4)).version(rs.getInt(5)).build();
        }
    }
}

