/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CountOpenTxnsHandler
implements QueryHandler<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(CountOpenTxnsHandler.class);

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT COUNT(*) FROM \"TXNS\" WHERE \"TXN_STATE\" = :state";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("state", (Object)TxnStatus.OPEN.getSqlConst());
    }

    public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (!rs.next()) {
            LOG.error("Transaction database not properly configured, can't find txn_state from TXNS.");
            return -1;
        }
        Long numOpen = rs.getLong(1);
        if (numOpen > Integer.MAX_VALUE) {
            LOG.error("Open transaction count above {}, can't count that high!", (Object)Integer.MAX_VALUE);
            return -1;
        }
        return numOpen.intValue();
    }
}

