/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetOpenTxnTypeAndLockHandler
implements QueryHandler<TxnType> {
    private final SQLGenerator sqlGenerator;
    private final long txnId;

    public GetOpenTxnTypeAndLockHandler(SQLGenerator sqlGenerator, long txnId) {
        this.sqlGenerator = sqlGenerator;
        this.txnId = txnId;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return this.sqlGenerator.addForUpdateClause("SELECT \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_ID\" = :id AND \"TXN_STATE\" = :state");
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("id", (Object)this.txnId).addValue("state", (Object)TxnStatus.OPEN.getSqlConst(), 1);
    }

    public TxnType extractData(ResultSet rs) throws SQLException, DataAccessException {
        return rs.next() ? TxnType.findByValue((int)rs.getInt(1)) : null;
    }
}

