/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.File;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final String HIVE_L4J = "metastore-log4j2.properties";
    private static final Logger l4j = LoggerFactory.getLogger(LogUtils.class);

    public static String initHiveLog4j(Configuration conf) throws LogInitializationException {
        return LogUtils.initHiveLog4jCommon(conf, MetastoreConf.ConfVars.LOG4J_FILE);
    }

    private static String initHiveLog4jCommon(Configuration conf, MetastoreConf.ConfVars confVarName) throws LogInitializationException {
        if (MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)confVarName).equals("")) {
            return LogUtils.initHiveLog4jDefault(conf, "", confVarName);
        }
        String log4jFileName = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)confVarName);
        File log4jConfigFile = new File(log4jFileName);
        boolean fileExists = log4jConfigFile.exists();
        if (!fileExists) {
            return LogUtils.initHiveLog4jDefault(conf, "Not able to find conf file: " + String.valueOf(log4jConfigFile), confVarName);
        }
        boolean async = LogUtils.checkAndSetAsyncLogging(conf);
        System.setProperty("isThreadContextMapInheritable", "true");
        Configurator.initialize(null, (String)log4jFileName);
        LogUtils.logConfigLocation();
        return "Logging initialized using configuration in " + String.valueOf(log4jConfigFile) + " Async: " + async;
    }

    private static boolean checkAndSetAsyncLogging(Configuration conf) {
        boolean asyncLogging = MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ASYNC_LOG_ENABLED);
        if (asyncLogging) {
            System.setProperty("Log4jContextSelector", "org.apache.logging.log4j.core.async.AsyncLoggerContextSelector");
            LogManager.setFactory((LoggerContextFactory)new Log4jContextFactory());
        }
        return asyncLogging;
    }

    private static String initHiveLog4jDefault(Configuration conf, String logMessage, MetastoreConf.ConfVars confVarName) throws LogInitializationException {
        URL hive_l4j = null;
        switch (confVarName) {
            case LOG4J_FILE: {
                hive_l4j = LogUtils.class.getClassLoader().getResource(HIVE_L4J);
                break;
            }
        }
        if (hive_l4j != null) {
            boolean async = LogUtils.checkAndSetAsyncLogging(conf);
            System.setProperty("isThreadContextMapInheritable", "true");
            Configurator.initialize(null, (String)hive_l4j.toString());
            LogUtils.logConfigLocation();
            return logMessage + "\nLogging initialized using configuration in " + String.valueOf(hive_l4j) + " Async: " + async;
        }
        throw new LogInitializationException(logMessage + "Unable to initialize logging using metastore-log4j2.properties, not found on CLASSPATH!");
    }

    private static void logConfigLocation() throws LogInitializationException {
        if (MetastoreConf.getHiveDefaultLocation() != null) {
            l4j.warn("DEPRECATED: Ignoring hive-default.xml found on the CLASSPATH at " + MetastoreConf.getHiveDefaultLocation().getPath());
        }
        if (MetastoreConf.getHiveSiteLocation() == null) {
            l4j.warn("hive-site.xml not found on CLASSPATH");
        } else {
            l4j.debug("Using hive-site.xml found on CLASSPATH at " + MetastoreConf.getHiveSiteLocation().getPath());
        }
    }

    public static class LogInitializationException
    extends Exception {
        LogInitializationException(String msg) {
            super(msg);
        }
    }
}

